! $Xorg: accessx.uil.cpp,v 1.2 2001/01/29 20:04:07 coskrey Exp $
!***************************************************************************
!*                                                                         *
!* Copyright (c) 2000 Compaq Computer Corporation                          *
!*                                                                         * 
!* The software (contained on this media) is proprietary to and embodies   *
!* the confidential technology of Compaq Computer Corporation.             * 
!* Possession use, duplication or disseminationof the software and media   *
!* in source and binary forms, with or without modification, is authorized,* 
!* provided that the following conditions are met:                         *
!*                                                                         *
!* 1.  Redistribution of source code must retain the above copyright       *
!* notice, this list of conditions, and the following disclaimer in the    *
!* documentation and!or other materials provided with the distribution.    *
!*                                                                         * 
!* 2.  Redistribution of binary forms must reproduce the above copyright   *
!* notice, this list of conditions, and the following disclaimer in the    *
!* documentation and!or othe rmatierals provided with the distribution.    *
!*                                                                         * 
!* 3.  The name of the Corporation may not be used to endorse or promote   *
!* products derived from this sfotware without specific prior written      *
!* permission from Compaq Computer Corporation.                            *
!*                                                                         * 
!* THE SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, *
!* INCLUDING BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY *
!* AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL *
!* THE CORPORATION BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,*
!* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO,      *
!* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR      *
!* PROFITS; OR BUSINESS INTERRUPTION), HOWEVER CAUSED AND ON ANY THEORY OF *
!* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    *
!* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS      *
!* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.            *
!*                                                                         *
!***************************************************************************
!
!************************************************************************
!*                                                                      *
!*         Copyright 1993 Sun Microsystems, Inc. All Rights Reserved.   *
!*                                                                      *
!*      Permission to use, copy, modify, and distribute this software   *
!*      and its documentation for any purpose and without fee is hereby *
!*      granted, provided that the above copyright notice appear in all *
!*      copies and that both that copyright notice and this permission  *
!*      notice appear in supporting documentation, and that the name of *
!*      Sun Microsystems, Inc. (SMI) not be used in advertising or      *
!*      publicity pertaining to distribution of the software without    *
!*      specific, written prior permission.                             *
!*                                                                      *
!*                                                                      *
!*      SMI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,      *
!*      INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND         *
!*      FITNESS, IN NO EVENT SHALL SMI BE LIABLE FOR ANY SPECIAL,       *
!*      INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER     *
!*      RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN      *
!*      ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,        *
!*      ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE     *
!*      OF THIS SOFTWARE.                                               *
!*                                                                      *
!************************************************************************

!************************************************************************
!*									*
!* AccessX	   						        *
!* 									*
!* 	This module is intended to provide access features for people	*
!*	with physical disabilities.  This is a Motif client that	*
!*	communicates with the AccessX server extension and allows us to	*
!*	get visual feedback regarding the state of the AccessX features.*
!*									*
!************************************************************************
module AccessX
    names = case_sensitive

#include "accessxstrings.uil"
! include file "accessxstrings.uil";

procedure
    CreateProc;
    ActivateProc;
    ChangeControlProc;

value
    MarginSize: 5;
    StatusMarginSize: 10;
    MouseStatusLeftOffset: 10;
    ToggleOffset: 9;

!*************** TOGGLE WIDGETS ***********************!
ENABLE_ACCESSX_TGL		:	1;
ONOFF_SOUND_TGL			:	2;
TIME_OUT_TGL			:	3;
SHOW_STATUS_TGL			:	4;

STICKY_KEYS_TGL			:	5;
MOUSE_KEYS_TGL			:	6;
TOGGLE_KEYS_TGL			:	7;
REPEAT_KEYS_TGL			:	8;
SLOW_KEYS_TGL			:	9;
BOUNCE_KEYS_TGL			:	10;

STICKY_MOD_SOUND_TGL		:	11;
STICKY_TWO_KEYS_TGL		:	12;
KRG_PRESS_SOUND_TGL		:	13;
KRG_ACCEPT_SOUND_TGL		:	14;

MAIN_TOGGLE_WIDGETS_MIN		:	ENABLE_ACCESSX_TGL;
MAIN_TOGGLE_WIDGETS_MAX		:	BOUNCE_KEYS_TGL;
SETTINGS_TOGGLE_WIDGETS_MIN 	:	STICKY_MOD_SOUND_TGL;
SETTINGS_TOGGLE_WIDGETS_MAX 	:	KRG_ACCEPT_SOUND_TGL;
TOGGLE_WIDGETS_MIN		:	ENABLE_ACCESSX_TGL;
TOGGLE_WIDGETS_MAX		:	KRG_ACCEPT_SOUND_TGL;

!************** SCALE WIDGETS *************************!
TIME_OUT_SCL			:	15;

MOUSE_MAX_SPEED_SCL		:	16;
MOUSE_ACCEL_SCL			:	17;
MOUSE_DELAY_SCL			:	18;

KRG_REPEAT_DELAY_SCL		:	19;
KRG_REPEAT_RATE_SCL		:	20;
KRG_SLOW_DELAY_SCL		:	21;
KRG_DEBOUNCE_SCL		:	22;

SCALE_WIDGETS_MIN		:	TIME_OUT_SCL;
SCALE_WIDGETS_MAX		:	KRG_DEBOUNCE_SCL;

!************** MAIN MENU ITEMS ***********************!
LOAD_BTN			:	23;
SAVE_BTN			:	24;
EXIT_BTN			:	25;

ALL_BTN				:	26;
STICKYKEYS_BTN			:	27;
MOUSEKEYS_BTN			:	28;
KRG_BTN				:	29;

GENERAL_HELP_BTN		:	30;
STICKY_HELP_BTN			:	31;
MOUSE_HELP_BTN			:	32;
TOGGLE_HELP_BTN			:	33;
REPEAT_HELP_BTN			:	34;
SLOW_HELP_BTN			:	35;
BOUNCE_HELP_BTN			:	36;

!*************** HELP WIDGETS *************************!
HELP_TEXT			:	37;
CLOSE_HELP_BTN			:	38;

!*************** SETTINGS WINDOW **********************!
SETTINGS_OK_BTN			:	39;
SETTINGS_RESET_BTN		:	40;
SETTINGS_DEFAULTS_BTN		:	41;
SETTINGS_CANCEL_BTN		:	42;
SETTINGS_HELP_BTN		:	43;

!*************** STATUS *************************!
STATUS_FRAME			:	44;
DEFAULT_BUTTON_MENU		:	45;
MB1_BTN				:	46;
MB2_BTN				:	47;
MB3_BTN				:	48;
MB4_BTN				:	49;
MB5_BTN				:	50;

!*************** LOAD-SAVE WIDGETS *******************!
SAVE_DONE_CANCEL_BTN		:	51;
SAVE_DONE_OK_BTN		:	52;
SAVE_DONE_HELP_BTN		:	53;

SAVE_ERR_CANCEL_BTN		:	54;
SAVE_ERR_OK_BTN			:	55;
SAVE_ERR_HELP_BTN		:	56;

LOAD_DONE_CANCEL_BTN		:	57;
LOAD_DONE_OK_BTN		:	58;
LOAD_DONE_HELP_BTN		:	59;

LOAD_ERR_CANCEL_BTN		:	60;
LOAD_ERR_OK_BTN			:	61;
LOAD_ERR_HELP_BTN		:	62;

HELP_ERR_CANCEL_BTN		:	63;
HELP_ERR_OK_BTN			:	64;
HELP_ERR_HELP_BTN		:	65;

!*************** LABEL WIDGETS FOR SCALES *******************!
TIME_OUT_LBL			:	66;
MOUSE_MAX_SPEED_LBL		:	67;
MOUSE_ACCEL_LBL			:	68;
MOUSE_DELAY_LBL			:	69;
KRG_REPEAT_RATE_LBL		:	70;
KRG_REPEAT_DELAY_LBL		:	71;
KRG_SLOW_DELAY_LBL		:	72;
KRG_DEBOUNCE_LBL		:	73;
KRG_SOUND_WHEN_LBL		:	74;

STICKYKEYS_FRAME		:	75;
MOUSEKEYS_FRAME			:	76;
REPEATKEYS_FRAME		:	77;
SLOWKEYS_FRAME			:	78;
BOUNCEKEYS_FRAME		:	79;
TEST_FRAME			:	80;
SETTINGS_OK_FORM		:	81;

MODIFIERS_LBL			:       82;

LABEL_WIDGETS_MIN		:	MOUSE_MAX_SPEED_LBL;
LABEL_WIDGETS_MAX		:	KRG_SOUND_WHEN_LBL;
#ifdef __osf__
NUM_WIDGETS			:	MODIFIERS_LBL + 1;
NUM_RES_WIDGETS			:	SCALE_WIDGETS_MAX + 1;
#else
NUM_WIDGETS			:	83;
NUM_RES_WIDGETS			:	23;
#endif

!************************************************************************
!*									*
!* The Main Window							*
!*									*
!************************************************************************
object AccessXMainWindow: XmMainWindow {
    controls {
	XmMenuBar {
	    arguments {
		XmNmenuHelpWidget = XmCascadeButtonGadget HelpCascade;
	    };
	    controls {
		XmCascadeButtonGadget FileCascade;
		XmCascadeButtonGadget AdjustCascade;
		XmCascadeButtonGadget HelpCascade;
	    };
	};
	XmForm {
            arguments {
	        XmNmarginWidth  = MarginSize;
	        XmNmarginHeight = MarginSize;
	    };
	    controls {
	        XmForm		CustomizeGeneralForm;
    	        XmForm  	TimeOutForm;
	        XmRowColumn	FeaturesForm;
	    };
	};
    };
};

!************************************************************************
!*									*
!* The Main Window's menu bar.						*
!*									*
!************************************************************************
object FileCascade: XmCascadeButton {
    arguments {
	XmNlabelString = FileString;
	XmNmnemonic    = FileMnemonic;
    };	
    controls {
	XmPulldownMenu {
	    arguments {
	    XmNtearOffModel = XmTEAR_OFF_ENABLED;
	    };
	    controls {
		XmPushButtonGadget 	LoadButton;
		XmPushButtonGadget 	SaveButton;
		XmSeparatorGadget 	MenuSeparator;
		XmPushButtonGadget 	ExitButton;
	    };
	};
    };
};

object LoadButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = LoadString;
	XmNmnemonic    = LoadMnemonic;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(LOAD_BTN);
	XmNactivateCallback = procedure ActivateProc(LOAD_BTN);
    };
};

object SaveButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = SaveString;
	XmNmnemonic    = SaveMnemonic;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(SAVE_BTN);
	XmNactivateCallback = procedure ActivateProc(SAVE_BTN);
    };
};

object MenuSeparator: XmSeparatorGadget {
    arguments {
	XmNorientation = XmHORIZONTAL;
    };
};

object ExitButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = ExitString;
	XmNmnemonic    = ExitMnemonic;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(EXIT_BTN);
	XmNactivateCallback = procedure ActivateProc(EXIT_BTN);
    };
};

object AdjustCascade: XmCascadeButton {
    arguments {
	XmNlabelString = AdjustString;
	XmNmnemonic    = AdjustMnemonic;
    };	
    controls {
	XmPulldownMenu {
	    arguments {
	        XmNtearOffModel = XmTEAR_OFF_ENABLED;
	    };
	    controls {
		XmPushButtonGadget 	AllButton;
	    	XmSeparatorGadget	AdjustSeparator;
		XmPushButtonGadget 	StickyKeysButton;
		XmPushButtonGadget 	MouseKeysButton;
		XmPushButtonGadget 	KRGButton;
	    };
	};
    };
};

object AllButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = AllString;
	XmNmnemonic    = AllMnemonic;
    };
    callbacks {
        MrmNcreateCallback  = procedure CreateProc(ALL_BTN);
	XmNactivateCallback = procedure ActivateProc(ALL_BTN);
    };
};

object AdjustSeparator: XmSeparatorGadget {
    arguments {
	XmNorientation = XmHORIZONTAL;
    };
};

object StickyKeysButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = StickyKeysString & ElipsesString;
	XmNmnemonic    = StickyKeysMnemonic;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(STICKYKEYS_BTN);
	XmNactivateCallback = procedure ActivateProc(STICKYKEYS_BTN);
    };
};

object MouseKeysButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = MouseKeysString & ElipsesString;
	XmNmnemonic    = MouseKeysMnemonic;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(MOUSEKEYS_BTN);
	XmNactivateCallback = procedure ActivateProc(MOUSEKEYS_BTN);
    };
};

object KRGButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = KRGString & ElipsesString;
	XmNmnemonic    = KRGMnemonic;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(KRG_BTN);
	XmNactivateCallback = procedure ActivateProc(KRG_BTN);
    };
};

object HelpCascade: XmCascadeButton {
    arguments {
	XmNlabelString = HelpString;
	XmNmnemonic    = HelpMnemonic;
    };
    controls {
	XmPulldownMenu {
	    arguments {
		XmNtearOffModel = XmTEAR_OFF_ENABLED;
	    };
 	    controls {
		XmPushButtonGadget GeneralHelpButton;
		XmPushButtonGadget StickyKeysHelpButton;
		XmPushButtonGadget MouseKeysHelpButton;
		XmPushButtonGadget ToggleKeysHelpButton; 
		XmPushButtonGadget RepeatKeysHelpButton;
		XmPushButtonGadget SlowKeysHelpButton;
		XmPushButtonGadget BounceKeysHelpButton;
	    };
	};
    };
};

object GeneralHelpButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = GeneralString & ElipsesString;
	XmNmnemonic    = GeneralMnemonic;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(GENERAL_HELP_BTN);
	XmNactivateCallback = procedure ActivateProc(GENERAL_HELP_BTN);
    };
};

object StickyKeysHelpButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = StickyKeysString & ElipsesString;
	XmNmnemonic    = StickyMnemonic;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(STICKY_HELP_BTN);
	XmNactivateCallback = procedure ActivateProc(STICKY_HELP_BTN);
    };
};

object MouseKeysHelpButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = MouseKeysString & ElipsesString;
	XmNmnemonic    = MouseMnemonic;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(MOUSE_HELP_BTN);
	XmNactivateCallback = procedure ActivateProc(MOUSE_HELP_BTN);
    };
};

object ToggleKeysHelpButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = ToggleKeysString & ElipsesString;
	XmNmnemonic    = ToggleMnemonic;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(TOGGLE_HELP_BTN);
	XmNactivateCallback = procedure ActivateProc(TOGGLE_HELP_BTN);
    };
};

object RepeatKeysHelpButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = RepeatKeysString & ElipsesString;
	XmNmnemonic    = RepeatMnemonic;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(REPEAT_HELP_BTN);
	XmNactivateCallback = procedure ActivateProc(REPEAT_HELP_BTN);
    };
};

object SlowKeysHelpButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = SlowKeysString & ElipsesString;
	XmNmnemonic    = SlowMnemonic;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(SLOW_HELP_BTN);
	XmNactivateCallback = procedure ActivateProc(SLOW_HELP_BTN);
    };
};

object BounceKeysHelpButton: XmPushButtonGadget {
    arguments {
	XmNlabelString = BounceKeysString & ElipsesString;
	XmNmnemonic    = BounceMnemonic;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(BOUNCE_HELP_BTN);
	XmNactivateCallback = procedure ActivateProc(BOUNCE_HELP_BTN);
    };
};

!************************************************************************
!*									*
!* The Main Window's Main Form.						*
!*									*
!************************************************************************
object CustomizeGeneralForm: XmForm {
    arguments {
	XmNleftAttachment 	= XmATTACH_FORM;
	XmNrightAttachment 	= XmATTACH_FORM;
	XmNtopAttachment 	= XmATTACH_FORM;
	XmNmarginWidth 	= MarginSize;
	XmNmarginHeight 	= MarginSize;
    };
    controls {
	XmToggleButtonGadget EnableAccessXToggle;
	XmToggleButtonGadget SoundOnOffToggle;
	XmToggleButtonGadget ShowStatusToggle;
    };
};

object EnableAccessXToggle: XmToggleButtonGadget {
    arguments {
	XmNleftAttachment = XmATTACH_FORM;
	XmNtopAttachment  = XmATTACH_FORM;
	XmNlabelString    = EnableString & SpaceString & HotKeysString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(ENABLE_ACCESSX_TGL);
	XmNvalueChangedCallback = procedure ChangeControlProc(ENABLE_ACCESSX_TGL);
    };
};

object SoundOnOffToggle: XmToggleButtonGadget {
    arguments {
	XmNrightAttachment= XmATTACH_FORM;
	XmNtopAttachment  = XmATTACH_FORM;
	XmNlabelString    = SoundOnOffString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(ONOFF_SOUND_TGL);
	XmNvalueChangedCallback = procedure ChangeControlProc(ONOFF_SOUND_TGL);
    };
};

object ShowStatusToggle: XmToggleButtonGadget {
    arguments {
	XmNleftAttachment = XmATTACH_FORM;
	XmNtopAttachment  = XmATTACH_WIDGET;
	XmNtopWidget	  = XmToggleButtonGadget SoundOnOffToggle;
	XmNlabelString    = ShowStatusString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(SHOW_STATUS_TGL);
	XmNvalueChangedCallback = procedure ActivateProc(SHOW_STATUS_TGL);
    };
};

object TimeOutForm: XmForm {
    arguments {
	XmNmarginWidth 		= MarginSize;
	XmNmarginHeight 	= MarginSize;
	XmNleftAttachment 	= XmATTACH_FORM;
	XmNrightAttachment 	= XmATTACH_FORM;
	XmNtopAttachment 	= XmATTACH_WIDGET;
	XmNtopWidget 		= XmForm CustomizeGeneralForm;
    };
    controls {
	XmToggleButtonGadget TimeOutToggle;
	XmLabelGadget        TimeOutLabel;
	XmScale              TimeOutScale;
    };
};

object TimeOutToggle: XmToggleButtonGadget {
    arguments {
	XmNleftAttachment   = XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNlabelString      = TimeOutString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(TIME_OUT_TGL);
	XmNvalueChangedCallback = procedure ChangeControlProc(TIME_OUT_TGL);
    };
};

object TimeOutLabel: XmLabelGadget {
    arguments {
	XmNleftAttachment   	= XmATTACH_WIDGET;
	XmNleftWidget		= XmToggleButtonGadget TimeOutToggle;
	XmNleftOffset		= MarginSize;
	XmNbottomAttachment    	= XmATTACH_FORM;
	XmNbottomOffset     	= ToggleOffset;
	XmNlabelString      	= TimeString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(TIME_OUT_LBL);
    };
};

object TimeOutScale: XmScale { 
    arguments {
	XmNleftAttachment	= XmATTACH_WIDGET;
	XmNleftWidget		= XmLabelGadget TimeOutLabel;
	XmNrightAttachment 	= XmATTACH_FORM;
	XmNtopAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment 	= XmATTACH_FORM;
	XmNbottomOffset     	= ToggleOffset;
	XmNorientation 		= XmHORIZONTAL;
	XmNshowValue 		= true;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(TIME_OUT_SCL);
	XmNvalueChangedCallback = procedure ChangeControlProc(TIME_OUT_SCL);
    };
};

object FeaturesForm: XmRowColumn {
    arguments {
	XmNleftAttachment	= XmATTACH_FORM;
	XmNrightAttachment	= XmATTACH_FORM;
	XmNtopAttachment	= XmATTACH_WIDGET;
	XmNtopWidget		= XmForm TimeOutForm;
	XmNtopOffset 		= 2*MarginSize;
	XmNbottomAttachment 	= XmATTACH_FORM;
	XmNmarginWidth  	= MarginSize;
	XmNmarginHeight 	= MarginSize;
	XmNorientation  	= XmVERTICAL;
	XmNpacking      	= XmPACK_COLUMN;
	XmNnumColumns   	= 2;
    };
    controls {
	XmFrame TurnOnOffFeatures;
	XmFrame	KRGFeatures;
    };
};

object TurnOnOffFeatures: XmFrame {
    controls {
	XmLabelGadget EnableLabel;
	XmForm        FeaturesManagerForm;
    };
};

object EnableLabel: XmLabelGadget {
    arguments {
	XmNlabelString = KeyboardControlString;
	XmNchildType   = XmFRAME_TITLE_CHILD;
    };
};

object FeaturesManagerForm: XmForm {
    controls {
	XmRowColumn	TurnOnOffForm;
    };
};

object TurnOnOffForm: XmRowColumn {
    arguments {
	XmNmarginWidth  = MarginSize;
	XmNmarginHeight = MarginSize;
	XmNorientation  = XmVERTICAL;
	XmNpacking      = XmPACK_COLUMN;
	XmNnumColumns   = 1;
    };
    controls {
	XmToggleButtonGadget StickyKeysToggle;
	XmToggleButtonGadget MouseKeysToggle;
	XmToggleButtonGadget ToggleKeysToggle;
    };
};

object StickyKeysToggle: XmToggleButtonGadget {
    arguments {
	XmNlabelString = StickyKeysString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(STICKY_KEYS_TGL);
	XmNvalueChangedCallback = procedure ChangeControlProc(STICKY_KEYS_TGL);
    };
};

object MouseKeysToggle: XmToggleButtonGadget {
    arguments {
	XmNlabelString = MouseKeysString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(MOUSE_KEYS_TGL);
	XmNvalueChangedCallback = procedure ChangeControlProc(MOUSE_KEYS_TGL);
    };
};

object ToggleKeysToggle: XmToggleButtonGadget {
    arguments {
	XmNlabelString = ToggleKeysString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(TOGGLE_KEYS_TGL);
	XmNvalueChangedCallback = procedure ChangeControlProc(TOGGLE_KEYS_TGL);
    };
};

object KRGFeatures: XmFrame {
    controls {
	XmLabelGadget KRGLabel;
	XmForm        KRGManagerForm;
    };
};

object KRGLabel: XmLabelGadget {
    arguments {
	XmNlabelString = KRGString;
	XmNchildType   = XmFRAME_TITLE_CHILD;
    };
};

object KRGManagerForm: XmForm {
    controls {
	XmRowColumn	KRGForm;
    };
};	

object KRGForm: XmRowColumn {
    arguments {
	XmNmarginWidth  = MarginSize;
	XmNmarginHeight = MarginSize;
	XmNorientation  = XmVERTICAL;
	XmNpacking      = XmPACK_COLUMN;
	XmNnumColumns   = 1;
    };
    controls {
	XmToggleButtonGadget RepeatKeysToggle;
	XmToggleButtonGadget SlowKeysToggle;
	XmToggleButtonGadget BounceKeysToggle;
    };
};

object RepeatKeysToggle: XmToggleButtonGadget {
    arguments {
	XmNlabelString = RepeatKeysString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(REPEAT_KEYS_TGL);
	XmNvalueChangedCallback = procedure ChangeControlProc(REPEAT_KEYS_TGL);
    };
};

object SlowKeysToggle: XmToggleButtonGadget {
    arguments {
!	XmNindicatorType = XmONE_OF_MANY;
	XmNlabelString   = SlowKeysString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(SLOW_KEYS_TGL);
	XmNvalueChangedCallback = procedure ChangeControlProc(SLOW_KEYS_TGL);
    };
};

object BounceKeysToggle: XmToggleButtonGadget {
    arguments {
!	XmNindicatorType = XmONE_OF_MANY;
	XmNlabelString   = BounceKeysString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(BOUNCE_KEYS_TGL);
	XmNvalueChangedCallback = procedure ChangeControlProc(BOUNCE_KEYS_TGL);
    };
};

!************************************************************************
!*    									*
!* Edit Settings Dialog							*
!*									*
!************************************************************************
object SettingsDialog: XmFormDialog {
    arguments {
	XmNdialogTitle  = AdjustTitle; 
	XmNdefaultButton= XmPushButtonGadget OKButton;
	XmNmarginWidth  = MarginSize;
	XmNmarginHeight = MarginSize;
    };
    controls {
	XmFrame CustomizeStickyKeysFrame;
	XmFrame CustomizeMouseKeysFrame;
	XmFrame CustomizeRepeatKeysFrame;
	XmFrame CustomizeSlowKeysFrame;
	XmFrame CustomizeBounceKeysFrame;
	XmFrame CustomizeFeaturesTestFrame;
	XmForm  SettingsOKForm;
    };
};

object CustomizeStickyKeysFrame: XmFrame {
    arguments {
	XmNleftAttachment  = XmATTACH_FORM;
	XmNrightAttachment = XmATTACH_FORM;
	XmNtopAttachment   = XmATTACH_FORM;
    };
    controls {
	XmLabelGadget CustomizeStickyKeysLabel;
	XmForm 	  CustomizeStickyKeysForm;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(STICKYKEYS_FRAME);
    };
};

object CustomizeStickyKeysForm: XmForm {
    arguments {
	XmNmarginWidth  = MarginSize;
	XmNmarginHeight = MarginSize;
    };
    controls {
	XmToggleButtonGadget StickyTwoKeysToggle;
	XmToggleButtonGadget StickyModSoundToggle;
    };
};

object CustomizeStickyKeysLabel: XmLabelGadget {
    arguments {
	XmNlabelString = StickyKeysString;
	XmNchildType   = XmFRAME_TITLE_CHILD;
    };
};

object StickyModSoundToggle: XmToggleButtonGadget {
    arguments {
	XmNtopAttachment  = XmATTACH_FORM;
	XmNrightAttachment = XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNlabelString    = SoundOnModString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(STICKY_MOD_SOUND_TGL);
	XmNvalueChangedCallback = procedure ChangeControlProc(STICKY_MOD_SOUND_TGL);
    };
};

object StickyTwoKeysToggle: XmToggleButtonGadget {
    arguments {
	XmNleftAttachment 	= XmATTACH_FORM;
	XmNtopAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNlabelString 	= TwoKeysString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(STICKY_TWO_KEYS_TGL);
	XmNvalueChangedCallback = procedure ChangeControlProc(STICKY_TWO_KEYS_TGL);
    };
};

object CustomizeMouseKeysFrame: XmFrame {
    arguments {
	XmNleftAttachment  = XmATTACH_FORM;
	XmNrightAttachment = XmATTACH_FORM;
	XmNtopAttachment   = XmATTACH_WIDGET;
	XmNtopWidget       = XmFrame CustomizeStickyKeysFrame;
	XmNtopOffset       = MarginSize;
    };
    controls {
	XmLabelGadget CustomizeMouseKeysLabel;
	XmForm        CustomizeMouseKeysForm;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(MOUSEKEYS_FRAME);
    };
};     
        
object CustomizeMouseKeysForm: XmForm {
    arguments {
	XmNmarginHeight = MarginSize;
	XmNmarginWidth = MarginSize;
    };
    controls {
	XmLabelGadget MouseMaxSpeedLabel;
	XmScale	  MouseMaxSpeedScale;
	XmLabelGadget MouseAccelLabel;
	XmScale	  MouseAccelScale;
	XmLabelGadget MouseDelayLabel;
	XmScale	  MouseDelayScale;
    };
};     
 
object CustomizeMouseKeysLabel: XmLabelGadget {
    arguments {
	XmNchildType = XmFRAME_TITLE_CHILD;
	XmNlabelString = MouseKeysString;
    };
};

object MouseDelayLabel: XmLabelGadget {
    arguments {	
	XmNleftAttachment   = XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNlabelString      = MouseDelayString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(MOUSE_DELAY_LBL);
    };
};

object MouseDelayScale: XmScale {
    arguments {
	XmNleftAttachment 	= XmATTACH_WIDGET;
	XmNleftWidget      	= XmLabelGadget MouseDelayLabel;
	XmNrightAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNorientation 	= XmHORIZONTAL;
	XmNshowValue 	= true;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(MOUSE_DELAY_SCL);
	XmNvalueChangedCallback = procedure ChangeControlProc(MOUSE_DELAY_SCL);
    };
};

object MouseAccelLabel: XmLabelGadget {
    arguments {	
	XmNleftAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_WIDGET;
	XmNbottomWidget 	= XmScale MouseDelayScale;
	XmNlabelString 	= MouseAccelString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(MOUSE_ACCEL_LBL);
    };
};	

object MouseAccelScale: XmScale {
    arguments {
	XmNleftAttachment 	= XmATTACH_WIDGET;
	XmNleftWidget 		= XmLabelGadget MouseAccelLabel;
	XmNrightAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment 	= XmATTACH_WIDGET;
	XmNbottomWidget 	= XmScale MouseDelayScale;
	XmNorientation 		= XmHORIZONTAL;
	XmNshowValue 		= true;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(MOUSE_ACCEL_SCL);
	XmNvalueChangedCallback = procedure ChangeControlProc(MOUSE_ACCEL_SCL);
    };
};

object MouseMaxSpeedLabel: XmLabelGadget {
    arguments {	
	XmNleftAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_WIDGET;
	XmNbottomWidget 	= XmScale MouseAccelScale;
	XmNlabelString 	= MouseMaxSpeedString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(MOUSE_MAX_SPEED_LBL);
    };
};

object MouseMaxSpeedScale: XmScale {
    arguments {
	XmNleftAttachment 	= XmATTACH_WIDGET;
	XmNleftWidget 	= XmLabelGadget MouseMaxSpeedLabel;
	XmNrightAttachment 	= XmATTACH_FORM;
	XmNtopAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_WIDGET;
	XmNbottomWidget 	= XmScale MouseAccelScale;
	XmNorientation 	= XmHORIZONTAL;
	XmNshowValue 	= true;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(MOUSE_MAX_SPEED_SCL);
	XmNvalueChangedCallback = procedure ChangeControlProc(MOUSE_MAX_SPEED_SCL);
    };
};

object CustomizeRepeatKeysFrame: XmFrame {
    arguments {
	XmNleftAttachment  = XmATTACH_FORM;
	XmNrightAttachment = XmATTACH_FORM;
	XmNtopAttachment   = XmATTACH_WIDGET;
	XmNtopWidget       = XmFrame CustomizeMouseKeysFrame;
	XmNtopOffset       = MarginSize;
    };
    controls {
	XmLabelGadget CustomizeRepeatKeysLabel;
	XmForm 	  CustomizeRepeatKeysForm;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(REPEATKEYS_FRAME);
    };
};	

object CustomizeRepeatKeysLabel: XmLabelGadget {
    arguments {
	XmNchildType   = XmFRAME_TITLE_CHILD;
	XmNlabelString = RepeatKeysString;
    };
};

object CustomizeRepeatKeysForm: XmForm {
    arguments {
	XmNmarginWidth  = MarginSize;
	XmNmarginHeight = MarginSize;
    };
    controls {
	XmLabelGadget 	KRGRepeatDelayLabel;
	XmScale         KRGRepeatDelayScale;
	XmLabelGadget 	KRGRepeatRateLabel;
	XmScale	  	KRGRepeatRateScale;
    };
};	

object KRGRepeatDelayLabel: XmLabelGadget {
    arguments {
	XmNleftAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNlabelString 	= RepeatDelayString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(KRG_REPEAT_DELAY_LBL);
    };
};

object KRGRepeatDelayScale: XmScale {
    arguments {
	XmNleftAttachment 	= XmATTACH_WIDGET;
	XmNleftWidget 	= XmLabelGadget KRGRepeatDelayLabel;
	XmNrightAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNshowValue 	= true;
	XmNorientation 	= XmHORIZONTAL;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(KRG_REPEAT_DELAY_SCL);
	XmNvalueChangedCallback = procedure ChangeControlProc(KRG_REPEAT_DELAY_SCL);
    };
};

object KRGRepeatRateLabel: XmLabelGadget {
    arguments {
	XmNleftAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment 	= XmATTACH_WIDGET;
	XmNbottomWidget 	= XmScale KRGRepeatDelayScale;
	XmNlabelString 		= RepeatRateString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(KRG_REPEAT_RATE_LBL);
    };
};	

object KRGRepeatRateScale: XmScale {
    arguments {
	XmNleftAttachment 	= XmATTACH_WIDGET;
	XmNleftWidget 		= XmLabelGadget KRGRepeatRateLabel;
	XmNrightAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment 	= XmATTACH_WIDGET;
	XmNbottomWidget 	= XmScale KRGRepeatDelayScale;
	XmNshowValue 		= true;
	XmNorientation 		= XmHORIZONTAL;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(KRG_REPEAT_RATE_SCL);
	XmNvalueChangedCallback = procedure ChangeControlProc(KRG_REPEAT_RATE_SCL);
    };
};

object CustomizeSlowKeysFrame: XmFrame {
    arguments {
	XmNleftAttachment  = XmATTACH_FORM;
	XmNrightAttachment = XmATTACH_FORM;
	XmNtopAttachment   = XmATTACH_WIDGET;
	XmNtopWidget       = XmFrame CustomizeRepeatKeysFrame;
	XmNtopOffset       = MarginSize;
    };
    controls {
	XmLabelGadget CustomizeSlowKeysLabel;
	XmForm 	  CustomizeSlowForm;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(SLOWKEYS_FRAME);
    };
};

object CustomizeSlowKeysLabel: XmLabelGadget {
    arguments {
	XmNchildType   = XmFRAME_TITLE_CHILD;
	XmNlabelString = SlowKeysString;
    };
};

object CustomizeSlowForm: XmForm {
    arguments {
	XmNmarginWidth  = MarginSize;
	XmNmarginHeight = MarginSize;
    };
    controls {
	XmLabelGadget 	 SlowKeysSoundLabel;
	XmToggleButtonGadget SlowKeysOnPressToggle;
	XmToggleButtonGadget SlowKeysOnAcceptToggle;
	XmLabelGadget 	 KRGSlowKeysDelayLabel;
	XmScale 		 KRGSlowKeysDelayScale;
    };
};

object SlowKeysSoundLabel: XmLabelGadget {
    arguments {
	XmNtopAttachment  = XmATTACH_FORM;
	XmNleftAttachment = XmATTACH_FORM;
	XmNlabelString    = SoundWhenString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(KRG_SOUND_WHEN_LBL);
    };
};

object SlowKeysOnPressToggle: XmToggleButtonGadget {
    arguments {
	XmNleftAttachment 	= XmATTACH_WIDGET;
	XmNleftWidget 	= XmLabelGadget SlowKeysSoundLabel;
	XmNtopAttachment 	= XmATTACH_OPPOSITE_WIDGET;
	XmNtopWidget 	= XmLabelGadget SlowKeysSoundLabel;
	XmNbottomAttachment = XmATTACH_OPPOSITE_WIDGET;
	XmNbottomWidget 	= XmLabelGadget SlowKeysSoundLabel;
	XmNlabelString 	= SoundOnPressString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(KRG_PRESS_SOUND_TGL);
	XmNvalueChangedCallback = procedure ChangeControlProc(KRG_PRESS_SOUND_TGL);
    };
};

object SlowKeysOnAcceptToggle: XmToggleButtonGadget {
    arguments {
	XmNleftAttachment 	= XmATTACH_WIDGET;
	XmNleftWidget 	= XmToggleButtonGadget SlowKeysOnPressToggle;
	XmNtopAttachment 	= XmATTACH_OPPOSITE_WIDGET;
	XmNtopWidget 	= XmLabelGadget SlowKeysSoundLabel;
	XmNbottomAttachment = XmATTACH_OPPOSITE_WIDGET;
	XmNbottomWidget 	= XmLabelGadget SlowKeysSoundLabel;
	XmNlabelString 	= SoundOnAcceptString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(KRG_ACCEPT_SOUND_TGL);
	XmNvalueChangedCallback = procedure ChangeControlProc(KRG_ACCEPT_SOUND_TGL);
    };
};

object KRGSlowKeysDelayLabel: XmLabelGadget {
    arguments {
	XmNleftAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNlabelString 	= SlowKeysDelayString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(KRG_SLOW_DELAY_LBL);
    };
};

object KRGSlowKeysDelayScale: XmScale {
    arguments {
	XmNleftAttachment 	= XmATTACH_WIDGET;
	XmNleftWidget 	= XmLabelGadget KRGSlowKeysDelayLabel;
	XmNrightAttachment 	= XmATTACH_FORM;
	XmNtopAttachment 	= XmATTACH_WIDGET;
	XmNtopWidget 	= XmLabelGadget SlowKeysSoundLabel;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNorientation 	= XmHORIZONTAL;
	XmNshowValue 	= true;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(KRG_SLOW_DELAY_SCL);
	XmNvalueChangedCallback = procedure ChangeControlProc(KRG_SLOW_DELAY_SCL);
    };
};
 
object CustomizeBounceKeysFrame: XmFrame {
    arguments {
	XmNleftAttachment  = XmATTACH_FORM;
	XmNrightAttachment = XmATTACH_FORM;
	XmNtopAttachment   = XmATTACH_WIDGET;
	XmNtopWidget       = XmFrame CustomizeSlowKeysFrame;
	XmNtopOffset       = MarginSize;
    };
    controls {
	XmLabelGadget CustomizeBounceKeysLabel;
	XmForm 	  CustomizeBounceKeysForm;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(BOUNCEKEYS_FRAME);
    };
};

object CustomizeBounceKeysLabel: XmLabelGadget {
    arguments {
	XmNchildType   = XmFRAME_TITLE_CHILD;
	XmNlabelString = BounceKeysString;
    };
};

object CustomizeBounceKeysForm: XmForm {
    arguments {
	XmNmarginWidth  = MarginSize;
	XmNmarginHeight = MarginSize;
    };
    controls {
	XmLabelGadget	KRGDebounceLabel;
	XmScale 		KRGDebounceScale;
    };
};	
 
object KRGDebounceLabel: XmLabelGadget {
    arguments {
	XmNleftAttachment   = XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNlabelString      = DebounceString;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(KRG_DEBOUNCE_LBL);
    };
};
	
object KRGDebounceScale: XmScale {
    arguments {
	XmNleftAttachment  	= XmATTACH_WIDGET;
	XmNleftWidget   	= XmLabelGadget KRGDebounceLabel;
	XmNrightAttachment 	= XmATTACH_FORM;
	XmNtopAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNorientation 	= XmHORIZONTAL;
	XmNshowValue 	= true;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(KRG_DEBOUNCE_SCL);
	XmNvalueChangedCallback = procedure ChangeControlProc(KRG_DEBOUNCE_SCL);
    };
};

object CustomizeFeaturesTestFrame: XmFrame {
    arguments {
	XmNleftAttachment  = XmATTACH_FORM;
	XmNrightAttachment = XmATTACH_FORM;
	XmNtopAttachment   = XmATTACH_WIDGET;
	XmNtopWidget       = XmFrame CustomizeBounceKeysFrame;
	XmNtopOffset       = MarginSize;
    };
    controls {
	XmLabelGadget FeaturesTestLabel;
	XmForm 	  FeaturesTestForm;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(TEST_FRAME);
    };
};
	
object FeaturesTestLabel: XmLabelGadget {
    arguments {
	XmNchildType   = XmFRAME_TITLE_CHILD;
	XmNlabelString = TestString;
    };
};

object FeaturesTestForm: XmForm {
    arguments {
	XmNmarginWidth  = MarginSize;
	XmNmarginHeight = MarginSize;
    };
    controls {
	XmText FeaturesTestText;
    };
};	

object FeaturesTestText: XmText {
    arguments {
	XmNleftAttachment   = XmATTACH_FORM;
	XmNrightAttachment  = XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
    };
};   

object SettingsOKForm: XmForm {
    arguments {
	XmNmarginWidth 	= MarginSize;
	XmNmarginHeight 	= MarginSize;
	XmNleftAttachment 	= XmATTACH_FORM;
	XmNrightAttachment 	= XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNtopAttachment 	= XmATTACH_WIDGET;
	XmNtopWidget 	= XmFrame CustomizeFeaturesTestFrame;
	XmNtopOffset 	= MarginSize;
    };
    controls {
	XmPushButtonGadget OKButton;
	XmPushButtonGadget ResetButton;
	XmPushButtonGadget DefaultsButton;
	XmPushButtonGadget CancelButton;
	XmPushButtonGadget HelpButton;
    };
    callbacks {
	MrmNcreateCallback      = procedure CreateProc(SETTINGS_OK_FORM);
    };
};

object OKButton: XmPushButtonGadget {
    arguments {
	XmNlabelString 	= OKString;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(SETTINGS_OK_BTN);
	XmNactivateCallback = procedure ActivateProc(SETTINGS_OK_BTN);
    };
};

object ResetButton: XmPushButtonGadget {
    arguments {
	XmNlabelString      = ResetString;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(SETTINGS_RESET_BTN);
	XmNactivateCallback = procedure ActivateProc(SETTINGS_RESET_BTN);
    };
};

object DefaultsButton: XmPushButtonGadget {
    arguments {
	XmNlabelString      = DefaultsString;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(SETTINGS_DEFAULTS_BTN);
	XmNactivateCallback = procedure ActivateProc(SETTINGS_DEFAULTS_BTN);
    };
};

object CancelButton: XmPushButtonGadget {
    arguments {
	XmNlabelString 	= CancelString;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(SETTINGS_CANCEL_BTN);
	XmNactivateCallback = procedure ActivateProc(SETTINGS_CANCEL_BTN);
    };
};

object HelpButton: XmPushButtonGadget {
    arguments {
	XmNlabelString 	= HelpString;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(SETTINGS_HELP_BTN);
	XmNactivateCallback = procedure ActivateProc(SETTINGS_HELP_BTN);
    };
};

!*****************************************************************
!*								 *
!* Status Dialog Box                                             *
!*                                                               *
!*****************************************************************

object  StatusDialog: XmForm {
    arguments {
        XmNresizePolicy = XmRESIZE_ANY;
	XmNmarginWidth  = MarginSize;
	XmNmarginHeight = MarginSize;
	XmNdialogTitle  = StatusString;
    };
    controls {
	XmOptionMenu 	DefaultButtonMenu;
	XmFrame 	StatusFrame;
    };
};

object DefaultButtonMenu: XmOptionMenu {
    arguments {
	XmNleftAttachment  = XmATTACH_FORM;
	XmNtopAttachment   = XmATTACH_FORM;
	XmNbottomAttachment= XmATTACH_FORM;
	XmNlabelString     = DefaultButtonString;
    };
    controls {
	XmPulldownMenu {
	    controls {
		XmPushButtonGadget 	MB1Button;
		XmPushButtonGadget 	MB2Button;
		XmPushButtonGadget 	MB3Button;
		XmPushButtonGadget 	MB4Button;
		XmPushButtonGadget 	MB5Button;
	    };
	};
    };
    callbacks {
	MrmNcreateCallback = procedure CreateProc(DEFAULT_BUTTON_MENU);
    };
};

object MB1Button: XmPushButtonGadget {
    arguments {
	XmNlabelString = MB1String;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(MB1_BTN);
	XmNactivateCallback = procedure ActivateProc(MB1_BTN);
    };
};

object MB2Button: XmPushButtonGadget {
    arguments {
	XmNlabelString = MB2String;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(MB2_BTN);
	XmNactivateCallback = procedure ActivateProc(MB2_BTN);
    };
};

object MB3Button: XmPushButtonGadget {
    arguments {
	XmNlabelString = MB3String;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(MB3_BTN);
	XmNactivateCallback = procedure ActivateProc(MB3_BTN);
    };
};

object MB4Button: XmPushButtonGadget {
    arguments {
	XmNlabelString = MB4String;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(MB4_BTN);
	XmNactivateCallback = procedure ActivateProc(MB4_BTN);
    };
};

object MB5Button: XmPushButtonGadget {
    arguments {
	XmNlabelString = MB5String;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(MB5_BTN);
	XmNactivateCallback = procedure ActivateProc(MB5_BTN);
    };
};

object StatusFrame: XmFrame {
    arguments {
	XmNleftAttachment  = XmATTACH_WIDGET;
	XmNleftWidget      = XmOptionMenu DefaultButtonMenu;
	XmNleftOffset	   = MarginSize;
	XmNrightAttachment = XmATTACH_FORM;
	XmNtopAttachment   = XmATTACH_OPPOSITE_WIDGET;
	XmNtopWidget       = XmOptionMenu DefaultButtonMenu;
	XmNbottomAttachment= XmATTACH_OPPOSITE_WIDGET;
	XmNbottomWidget    = XmOptionMenu DefaultButtonMenu;
    };
    controls {
	XmForm StatusForm;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(STATUS_FRAME);
    };
};

object StatusForm: XmForm {
    arguments {
        XmNresizePolicy = XmRESIZE_ANY;
	XmNmarginWidth  = StatusMarginSize;
	XmNmarginHeight = StatusMarginSize;
    };
    controls {  
	XmLabelGadget 	ModifiersLabel;
	XmLabelGadget	ModifiersStatusLabel;
    };
};

object ModifiersLabel: XmLabelGadget {
    arguments {
	XmNleftAttachment = XmATTACH_FORM;
	XmNtopAttachment  = XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNlabelString    = ModifiersString;
    };
};

object ModifiersStatusLabel: XmLabelGadget {
    arguments {
	XmNleftAttachment  = XmATTACH_WIDGET;
	XmNleftWidget      = XmLabelGadget ModifiersLabel;
	XmNrightAttachment = XmATTACH_FORM;
	XmNtopAttachment   = XmATTACH_FORM;
	XmNbottomAttachment = XmATTACH_FORM;
	XmNlabelString     = SpaceString;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(MODIFIERS_LBL);
    };
};

!**********************************************************************
!*                                                                    *
!* File Dialogs                                                       *
!*                                                                    *
!**********************************************************************
object SaveDoneDialog: XmMessageDialog {
    arguments {
	XmNdialogTitle  = SaveInfoString;
	XmNdialogType    = XmDIALOG_INFORMATION;
	XmNmessageString = SaveDoneString;
    };
    callbacks {
	XmNcancelCallback = procedure ActivateProc(SAVE_DONE_CANCEL_BTN);
	XmNokCallback     = procedure ActivateProc(SAVE_DONE_OK_BTN);
    };
};

object SaveErrorDialog: XmMessageDialog {
    arguments {
	XmNdialogTitle   = SaveErrorDialogString;
	XmNdialogType    = XmDIALOG_ERROR;
	XmNmessageString = SaveErrorString;
    };
    callbacks {
	XmNcancelCallback = procedure ActivateProc(SAVE_ERR_CANCEL_BTN);
	XmNokCallback     = procedure ActivateProc(SAVE_ERR_OK_BTN);
    };
};

object LoadDoneDialog: XmMessageDialog {
    arguments {
	XmNdialogTitle   = LoadInfoString;
	XmNdialogType    = XmDIALOG_INFORMATION;
	XmNmessageString = LoadDoneString;
    };
    callbacks {
	XmNcancelCallback = procedure ActivateProc(LOAD_DONE_CANCEL_BTN);
	XmNokCallback     = procedure ActivateProc(LOAD_DONE_OK_BTN);
    };
};

object LoadErrorDialog: XmMessageDialog {
    arguments {
	XmNdialogTitle   = LoadErrorDialogString;
	XmNdialogType    = XmDIALOG_ERROR;
	XmNmessageString = LoadErrorString;
    };
    callbacks {
	XmNcancelCallback = procedure ActivateProc(LOAD_ERR_CANCEL_BTN);
	XmNokCallback     = procedure ActivateProc(LOAD_ERR_OK_BTN);
    };
};

!****************************************************************
!*								*
!* Help Text Widget						*
!*								*
!****************************************************************
object HelpDialog: XmFormDialog {
    arguments {
	XmNmarginWidth  = MarginSize;
	XmNmarginHeight = MarginSize;
	XmNdialogTitle  = HelpWindowString;
	XmNresizePolicy = XmRESIZE_ANY;
    };
    controls {
#ifdef __osf__
	DXmScrolledCSText	HelpText;
#else
	XmScrolledText		HelpText;
#endif
	XmForm 		HelpCloseForm;
    };
};

#ifdef __osf__
object HelpText: DXmScrolledCSText {
    arguments {
	XmNeditable = false;
	XmNeditMode = XmMULTI_LINE_EDIT;
	XmNrows = 24;
	XmNcolumns      = 50;
	XmNwordWrap = true;
	XmNscrollHorizontal= false;
	XmNscrollVertical  = true;
	XmNleftAttachment  = XmATTACH_FORM;
	XmNrightAttachment = XmATTACH_FORM;
	XmNtopAttachment   = XmATTACH_FORM;
    };
    callbacks {
	MrmNcreateCallback = procedure CreateProc(HELP_TEXT);
    };
};
#else /* __osf__ */
object HelpText: XmScrolledText {
    arguments {
	XmNeditable = false;
	XmNeditMode = XmMULTI_LINE_EDIT;
	XmNscrollHorizontal = false;
	XmNrows=24;
	XmNcolumns=50;
	XmNwordWrap = true;
    };
    callbacks {
	MrmNcreateCallback = procedure CreateProc(HELP_TEXT);
    };
};
#endif

object HelpCloseForm: XmForm {
    arguments {
	XmNresizable	= false;
	XmNleftAttachment 	= XmATTACH_FORM;
	XmNrightAttachment 	= XmATTACH_FORM;
	XmNtopAttachment	= XmATTACH_WIDGET;
#ifdef __osf__
	XmNtopWidget 	= DXmScrolledCSText HelpText;
#else
	XmNtopWidget 	= XmScrolledText HelpText;
#endif
	XmNtopOffset 	= MarginSize;
	XmNbottomAttachment = XmATTACH_FORM;
    };
    controls {
	XmPushButtonGadget HelpCloseButton;
    };
};

object HelpCloseButton: XmPushButtonGadget {
    arguments {
	XmNlabelString 	= CloseString;
    };
    callbacks {
	MrmNcreateCallback  = procedure CreateProc(CLOSE_HELP_BTN);
	XmNactivateCallback = procedure ActivateProc(CLOSE_HELP_BTN);
    };
};

object HelpErrorDialog: XmMessageDialog {
    arguments {
	XmNdialogTitle   = HelpErrorDialogString;
	XmNdialogType    = XmDIALOG_ERROR;
	XmNmessageString = HelpErrorString;
    };
    callbacks {
	XmNcancelCallback = procedure ActivateProc(HELP_ERR_CANCEL_BTN);
	XmNokCallback     = procedure ActivateProc(HELP_ERR_OK_BTN);
    };
};

end module;
