'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbLatchModifiers __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbLatchModifiers \-  Latches and unlatches any of the eight real keyboard 
modifiers
.SH SYNOPSIS
.HP
.B Bool XkbLatchModifiers
.BI "(\^Display *" "display" "\^,"
.BI "unsigned int " "device_spec" "\^,"
.BI "unsigned int " "affect" "\^,"
.BI "unsigned int " "values" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
connection to the X server 
.TP
.I device_spec
device ID, or XkbUseCoreKbd
.TP
.I affect
mask of real modifiers whose lock state is to change
.TP
.I values
1 => lock, 0 => unlock; only for modifiers selected by affect
.SH DESCRIPTION
.LP
.I XkbLatchModifiers 
sends a request to the server to latch the real modifiers 
selected by both 
.I affect 
and 
.I values 
and to unlatch the real modifiers selected by 
.I affect
, but not selected by 
.I values. 

.I XkbLatchModifiers 
does not wait for a reply from the server. It returns True if 
the request was sent, and False otherwise.

The functions in this section that change the use of modifiers use a mask in the 
parameter affect. It is a bitwise inclusive OR of the legal modifier masks: 

.TS
c 
l 
l.
Table 1 Real Modifier Masks
_
Mask
_
ShiftMask
LockMask
ControlMask
Mod1Mask
Mod2Mask
Mod3Mask
Mod4Mask
Mod5Mask
.TE
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbLatchModifiers 
function returns True if a request was sent to the server to latch the real modifiers selected by both 
.I affect 
and 
.I values 
and to unlatch the real modifiers selected by 
.I affect
, but not selected by 
.I values. 
.TP 15
False
The 
.I XkbLatchModifiers 
function returns False if the request was not sent.

