.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbOpenDisplay __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbOpenDisplay \-  Checks for a compatible version of the Xkb extension in both 
the library and the server, and initializes the extension for use.
.SH SYNOPSIS
.HP
.B Display XkbOpenDisplay
.BI "(\^char *" "display_name" "\^,"
.BI "int *" "event_rtrn" "\^,"
.BI "int *" "error_rtrn" "\^,"
.BI "int *" "major_in_out" "\^,"
.BI "int *" "minor_in_out" "\^,"
.BI "int *" "reason_rtrn" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display_name
hardware display name, which determines the display and communications domain to 
be used
.TP
.I event_rtrn
backfilled with the extension base event code
.TP
.I error_rtrn
backfilled with the extension base error code
.TP
.I major_in_out
compile time lib major version in, server major version out
.TP
.I minor_in_out
compile time lib min version in, server minor version out 
.TP
.I reason_rtrn
backfilled with a status code 
.SH DESCRIPTION
.LP
As a convenience, you can use the function 
.I XkbOpenDisplay 
to perform these three 
tasks at once: open a connection to an X server, check for a compatible version 
of the Xkb extension in both the library and the server, and initialize the 
extension for use.

.I XkbOpenDisplay 
is a convenience function that opens an X display connection and 
initializes the X keyboard extension. In all cases, upon return 
.I reason_rtrn 
contains a status value indicating success or the type of failure. If 
.I major_in_out 
and 
.I minor_in_out 
are not NULL, 
.I XkbOpenDisplay 
first calls 
.I XkbLibraryVersion 
to determine whether the client library is compatible, passing 
it the values pointed to by 
.I major_in_out and 
.I minor_in_out. If the library is 
incompatible, 
.I XkbOpenDisplay backfills 
.I major_in_out 
and 
.I minor_in_out 
with the 
major and minor extension versions of the library being used and returns NULL. 
If the library is compatible, 
.I XkbOpenDisplay 
next calls 
.I XOpenDisplay 
with the 
.I display_name. 
If this fails, the function returns NULL. If successful, 
.I XkbOpenDisplay 
calls 
.I XkbQueryExtension 
and backfills the major and minor Xkb 
server extension version numbers in 
.I major_in_out and 
.I minor_in_out. If the server 
extension version is not compatible with the library extension version or if the 
server extension is not present, 
.I XkbOpenDisplay 
closes the display and returns 
NULL. When successful, the function returns the display connection.

The possible values for reason_rtrn are:

.IP \(bu 5
XkbOD_BadLibraryVersion indicates XkbLibraryVersion returned False.
.IP \(bu 5
XkbOD_ConnectionRefused indicates the display could not be opened.
.IP \(bu 5
XkbOD_BadServerVersion indicates the library and the server have incompatible 
extension versions.
.IP \(bu 5
XkbOD_NonXkbServer indicates the extension is not present in the X server.
.IP \(bu 5
XkbOD_Success indicates that the function succeeded.
.SH "RETURN VALUES"
.TP 15
NULL
The 
.I XkbOpenDisplay 
function returns NULL if the library is incompatible.
.sp
.in 20
The 
.I XkbOpenDisplay 
function returns NULL if the call to 
.I XOpenDisplay 
with the 
.I display_name
fails.
.sp
.in 20
The 
.I XkbOpenDisplay 
function returns NULL and closes the display if the server extension version is not 
compatible with the library extension version or if the server extension is not present.
.SH DIAGNOSTICS
.TP 15
.SM BadAccess
The Xkb extension has not been properly initialized
.SH "SEE ALSO"
.BR XkbLibraryVersion (__libmansuffix__),
.BR XkbQueryExtension (__libmansuffix__),
.BR XOpenDisplay (__libmansuffix__)
