'\" t
.\"     Title: xdevicebell
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.78.1 <http://docbook.sf.net/>
.\"      Date: 10/04/2016
.\"    Manual: \ \&
.\"    Source: \ \&
.\"  Language: English
.\"
.TH "XDEVICEBELL" "libmansuffix" "10/04/2016" "\ \&" "\ \&"
.\" -----------------------------------------------------------------
.\" * Define some portability stuff
.\" -----------------------------------------------------------------
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.\" http://bugs.debian.org/507673
.\" http://lists.gnu.org/archive/html/groff/2009-02/msg00013.html
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XDeviceBell \- ring a bell on a device supported through the input extension
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput\&.h>
.fi
.sp
.nf
Status XDeviceBell( Display *display,
                    XDevice *device,
                    XID feedbackclass,
                    XID feedbackid,
                    int percent);
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
device
       Specifies the device with which the bell is associated\&.
.fi
.sp
.nf
feedbackclass
       Specifies the class of the feedback with which the bell
       is associated\&.
.fi
.sp
.nf
feedbackid
       Specifies the id of the feedback with which the bell is
       associated\&.
.fi
.sp
.nf
percent
       Specifies the volume in the range \-100 to 100 at which
       the bell should be rung\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
The XDeviceBell request causes the server to ring a bell on the
specified feedback of the specified device, if possible\&. The
specified volume is relative to the base volume for the bell\&.
If an invalid device is specified, a BadDevice error will be
returned\&. The feedbackclass and feedbackid parameters contain
values returned by an XGetFeedbackControl request and uniquely
identify the bell to ring\&. If a feedbackclass is specified that
does not support a bell, or if a nonexistent feedbackid is
specified, or a percent value is specified that is not in the
range \-100 to 100, a BadValue error will be returned\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The volume at which the bell is rung when the percent argument
is nonnegative is: base \- [(base * percent) / 100] + percent
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The volume at which the bell rings when the percent argument is
negative is: base + [(base * percent) / 100]
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
To change the base volume of the bell, use
XChangeFeedbackControl\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XDeviceBell can generate a BadDevice or a BadValue error\&.
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadDevice
       An invalid device was specified\&. The specified device
       does not exist, or has not been opened by this client
       via XOpenInputDevice\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadValue
       An invalid feedbackclass, feedbackid, or percent value
       was specified\&.
.fi
.if n \{\
.RE
.\}
.SH "SEE ALSO"
.sp
.if n \{\
.RS 4
.\}
.nf
XChangeFeedbackControl(libmansuffix), XBell(libmansuffix)
.fi
.if n \{\
.RE
.\}
