.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XIntersectRegion __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XIntersectRegion, XUnionRegion, XUnionRectWithRegion, XSubtractRegion, XXorRegion, XOffsetRegion, XShrinkRegion \- region arithmetic
.SH SYNTAX
.HP
int XIntersectRegion\^(\^Region \fIsra\fP\^, Region \fIsrb\fP\^, Region
\fIdr_return\fP\^);
.HP
int XUnionRegion\^(\^Region \fIsra\fP\^, Region \fIsrb\fP\^, Region
\fIdr_return\fP\^);
.HP
int XUnionRectWithRegion\^(\^XRectangle *\fIrectangle\fP\^, Region
\fIsrc_region\fP\^, Region \fIdest_region_return\fP\^);
.HP
int XSubtractRegion\^(\^Region \fIsra\fP\^, Region \fIsrb\fP\^, Region
\fIdr_return\fP\^);
.HP
int XXorRegion\^(\^Region \fIsra\fP\^, Region \fIsrb\fP\^, Region
\fIdr_return\fP\^);
.HP
int XOffsetRegion\^(\^Region \fIr\fP\^, int \fIdx\fP\^, int \fIdy\fP\^);
.HP
int XShrinkRegion\^(\^Region \fIr\fP\^, int \fIdx\fP\^, int \fIdy\fP\^);
.SH ARGUMENTS
.IP \fIdest_region_return\fP 1i
Returns the destination region.
.IP \fIdr_return\fP 1i
Returns the result of the computation.
.IP \fIdx\fP 1i
.br
.ns
.IP \fIdy\fP 1i
Specify the x and y coordinates,
which define the amount you want to move or shrink the specified region.
.IP \fIr\fP 1i
Specifies the region.
.IP \fIrectangle\fP 1i
Specifies the rectangle.
.IP \fIsra\fP 1i
.br
.ns
.IP \fIsrb\fP 1i
Specify the two regions with which you want to perform the computation.
.IP \fIsrc_region\fP 1i
Specifies the source region to be used.
.SH DESCRIPTION
The
.B XIntersectRegion
function computes the intersection of two regions.
.LP
The
.B XUnionRegion
function computes the union of two regions.
.LP
The
.B XUnionRectWithRegion
function updates the destination region from a union of the specified rectangle
and the specified source region.
.LP
The
.B XSubtractRegion
function subtracts srb from sra and stores the results in dr_return.
.LP
The
.B XXorRegion
function calculates the difference between the union and intersection
of two regions.
.LP
The
.B XOffsetRegion
function moves the specified region by a specified amount.
.LP
The
.B XShrinkRegion
function reduces the specified region by a specified amount.
Positive values shrink the size of the region,
and negative values expand the region.
.SH "SEE ALSO"
.BR XCreateRegion (__libmansuffix__),
.BR XDrawRectangle (__libmansuffix__),
.BR XEmptyRegion (__libmansuffix__)
.br
\fI\*(xL\fP
