/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XGetCommand(display, w, argv_return, argc_return)
 *   Display		*display;
 *   Window		w;
 *   char		***argv_return;
 *   int		*argc_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetCommand	1
char    *TestName = "XGetCommand";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XGetCommand function
 */
static Display		*display;
static Window		w;
static char		***argv_return;
static int		*argc_return;


static int 	StatusReturn;

#include	"X11/Xatom.h"
char		**argvdef;
int		argcdef;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = DRW(Dsp);
	argv_return = &argvdef;
	argc_return = &argcdef;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XVisualInfo	*vp;
Status	status;
char	*nullstr = "<NULL>";
char	**strpp, *strp;
char	*str1 = "XTest string 1____";
char	*str2 = "XTest string 2__";
char	*str3 = "XTest string 3___";
int	nstrs = 3;
char	*prop[3];
char	**rstrings = NULL;
int	rcount = 0;
int	i;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetCommand-1.(A)");
	report_assertion("When the WM_COMMAND property is set for the window w, is");
	report_assertion("of type STRING, and is of format 8, then a call to");
	report_assertion("XGetCommand returns the property string list, which can be");
	report_assertion("freed with XFree, in the argv_return argument and the number");
	report_assertion("of strings in the argc_return argument and returns non-zero.");

	report_strategy("Set the WM_COMMAND property using XSetCommand.");
	report_strategy("Obtain the value of the WM_COMMAND property using XGetCommand.");
	report_strategy("Verify that the call did not return zero.");
	report_strategy("Verify that the number and value of the returned strings is correct.");

	tpstartup();
	setargs();
	prop[0] = str1;
	prop[1] = str2;
	prop[2] = str3;

	resetvinf(VI_WIN);
	nextvinf(&vp);
	w = makewin(display, vp);

	XSetCommand(display, w, prop, nstrs);

	argv_return = &rstrings;
	argc_return = &rcount;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetCommand(display, w, argv_return, argc_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == False) {
		delete("XGetCommand() returned False.");
		return;
	} else
		CHECK;

	if(rstrings == (char **) NULL) {
		report("Returned list of strings was NULL");
		FAIL;
	} else {
		CHECK;

		if(rcount != nstrs) {
			report("%d strings were returned instead of %d", rcount, nstrs);
			FAIL;
		} else {
			CHECK;

			for(i=0, strpp = rstrings; i< nstrs; i++, strpp++) {
				strp = (*strpp == NULL ? nullstr : *strpp);

				if(strcmp(strp, prop[i]) != 0) {
					report("String %d was \"%s\" instead of \"%s\"", i, strp, prop[i]);
					FAIL;
				} else
					CHECK;
			}

		}
		XFreeStringList(rstrings);
	}

	CHECKPASS(nstrs + 3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Status		status;
char		*s = "XTestString1";
XVisualInfo	*vp;
char		**rstrings = NULL;
int		rcount = 0;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetCommand-2.(A)");
	report_assertion("When the WM_COMMAND property is not set for the window w,");
	report_assertion("or is not of type STRING, or is not of format 8, then a call");
	report_assertion("to XGetCommand returns zero.");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Obtain the value of the unset WM_ICON_SIZES property using XGetCommand.");
	report_strategy("Verify that the function returned zero.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_COMMAND property to have format 16 type STRING using XChangeProperty.");
	report_strategy("Obtain the value of the WM_COMMAND property using XGetCommand.");
	report_strategy("Verify that the call returned zero");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_COMMAND property to have format 8 and type ATOM using XChangeProperty.");
	report_strategy("Obtain the value of the WM_COMMAND property using XGetCommand.");
	report_strategy("Verify that the call returned zero.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	argv_return = &rstrings;
	argc_return = &rcount;

	w = makewin(display, vp);

/* unset property */

	startcall(display);
	if (isdeleted())
		return;
	status = XGetCommand(display, w, argv_return, argc_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("%s() did not return False when the property was unset.", TestName);
		FAIL;
	} else
		CHECK;


	w = makewin(display, vp);

/* format 16 */
	XChangeProperty(display, w, XA_WM_COMMAND, XA_STRING, 16, PropModeReplace, (unsigned char *) s, strlen(s) );

	startcall(display);
	if (isdeleted())
		return;
	status = XGetCommand(display, w, argv_return, argc_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("%s() did not return False when property was of format 16.", TestName);
		FAIL;
	} else
		CHECK;


	w = makewin(display, vp);

/* type ATOM */
	XChangeProperty(display, w, XA_WM_COMMAND, XA_ATOM, 8, PropModeReplace, (unsigned char *) s, strlen(s) );

	startcall(display);
	if (isdeleted())
		return;
	status = XGetCommand(display, w, argv_return, argc_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("%s() did not return False when property was of type Atom.", TestName);
		FAIL;
	} else
		CHECK;


	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.9698 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetCommand-3.(B)");
	report_assertion("When insufficient memory is available to contain the string");
	report_assertion("list, then a call to XGetCommand returns a zero status.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.9698 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
