/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XStringListToTextProperty(list, count, text_prop_return)
 *   char		**list;
 *   int		count;
 *   XTextProperty	*text_prop_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XStringListToTextProperty	1
char    *TestName = "XStringListToTextProperty";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XStringListToTextProperty function
 */
static char		**list;
static int		count;
static XTextProperty	*text_prop_return;


static int 	StatusReturn;

#include	"X11/Xatom.h"

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	list = 0;
	count = 0;
	text_prop_return = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Status		status;
char		*str1 = "XtestString1_._.";
char		*str2 = "XtextString2._";
char		*str3 = "XtestString3._..";
char		*argv[3];
char		*value, *vp;
int		argc = 3;
int		i;
int		len;
XTextProperty	tp;
Window		win;
XVisualInfo	*vi;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XStringListToTextProperty-1.(A)");
	report_assertion("A call to XStringListToTextProperty sets the XTextProperty");
	report_assertion("structure named by the text_prop_return argument such that");
	report_assertion("the format component is 8, the encoding component is STRING,");
	report_assertion("the value component is the null-separated concatenation of");
	report_assertion("count of the character strings specified by the list");
	report_assertion("argument and terminated with an ASCII nul, the nitems");
	report_assertion("component is the total number of characters and separating");
	report_assertion("nulls and returns non-zero.");

	report_strategy("Create a window using XCreateWindow.");
	report_strategy("Create a XTextPropertyStructure using XStringListToTextProperty with three strings.");
	report_strategy("Verify that the call did not return zero.");
	report_strategy("Verify that the format component is 8.");
	report_strategy("Verify that the encoding component is STRING.");
	report_strategy("Verify that the value field is correctly set");
	report_strategy("Verify that the nitems field is correctly set.");
	report_strategy("Set the property WM_NAME to the returned XTextProperty using XSetTextProperty.");
	report_strategy("Verify that no error occurred.");
	report_strategy("Create a XTextPropertyStructure using XStringListToTextProperty no strings.");
	report_strategy("Verify that the call did not return zero.");
	report_strategy("Set the property WM_NAME to the returned XTextProperty using XSetTextProperty.");
	report_strategy("Verify that no error occurred.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vi);
	win = makewin(Dsp, vi);

	argv[0] = str1;
	argv[1] = str2;
	argv[2] = str3;

	len = 0;
	for(i=0; i< argc; i++)
		len += strlen(argv[i]) + 1;
	
	if((value = (char *)malloc(len)) == NULL) {
		delete("malloc() returned NULL.");
		return;
	} else
		CHECK;

	len--;
	vp = value;
	for(i=0; i< argc; i++) {
		strcpy(vp, argv[i]);
		vp += strlen(argv[i]) + 1;
		
	}

	list = argv;
	count = argc;
	text_prop_return = &tp;
	startcall(Dsp);
	if (isdeleted())
		return;
	status = XStringListToTextProperty(list, count, text_prop_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == 0) {
		delete("%s() returned zero.", TestName);
		return;
	} else
		CHECK;

	if( tp.format != 8 ) {
		report("The format component of the XTextProperty structure was %d instead of %d.", tp.format, 8);
		FAIL;
	} else
		CHECK;

	if( tp.encoding != XA_STRING) {
		report("The encoding component of the XTextProperty structure was %ld instead of %ld.", 
			(long) tp.encoding, (long) XA_STRING);
		FAIL;
	} else
		CHECK;

	if(tp.nitems != len) {
		report("The nitems component of the XTextProperty structure was %ld instead of %ld.", tp.nitems, len);
		FAIL;
	} else 
		CHECK;

	if(tp.value == NULL) {
		report("The value component of the XTextProperty structure was NULL.");
		FAIL;
	} else {
		CHECK;

		if(memcmp(tp.value, value, len+1) != 0) {
			report("The value component of the XTextProperty was not correct.");
			FAIL;
		} else
			CHECK;

		startcall(Dsp);
		XSetTextProperty(Dsp, win, &tp, XA_WM_NAME);
		endcall(Dsp);

		if(geterr() != Success) {
			report("Could not set property WM_NAME with the returned XTextProperty.");
			FAIL;
		} else
			CHECK;

		XFree((char*)tp.value);
	}


	free(value);

	list = (char **) NULL;
	count = 0;
	text_prop_return = &tp;
	startcall(Dsp);
	if (isdeleted())
		return;
	status = XStringListToTextProperty(list, count, text_prop_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == 0) {
		delete("%s() returned zero.", TestName);
		return;
	} else
		CHECK;

	startcall(Dsp);
	XSetTextProperty(Dsp, win, &tp, XA_WM_NAME);
	endcall(Dsp);

	if(geterr() != Success) {
		report("Could not set property WM_NAME with the returned XTextProperty.");
		FAIL;
	} else
		CHECK;

	if(tp.value != (unsigned char *) NULL)
		XFree((char*)tp.value);

	CHECKPASS(10);		

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.9761 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XStringListToTextProperty-2.(B)");
	report_assertion("When insufficient memory is available for the new value");
	report_assertion("string, then a call to XStringListToTextProperty does not");
	report_assertion("set any fields in the XTextProperty structure and returns");
	report_assertion("zero.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.9761 */

static void t003(){

Status		status;
char		*str1 = "XtestString1_._.";
char		*str2 = "XtextString2._";
char		*str3 = "XtestString3._..";
char		*argv[3];
int		argc = 3;
XTextProperty	tp;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XStringListToTextProperty-3.(A)");
	report_assertion("The new value string returned by a call to");
	report_assertion("XStringListToTextProperty can be freed with XFree.");

	report_strategy("Create a XTextProperty structure using XStringListToTextProperty.");
	report_strategy("Verify that the call did not return zero.");
	report_strategy("Release the allocated memory using XFree.");

	tpstartup();
	setargs();
	argv[0] = str1;
	argv[1] = str2;
	argv[2] = str3;

	list = argv;
	count = argc;
	text_prop_return = &tp;
	startcall(Dsp);
	if (isdeleted())
		return;
	status = XStringListToTextProperty(list, count, text_prop_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == 0) {
		delete("%s() returned zero.", TestName);
		return;
	} else
		CHECK;

	if(tp.value == NULL) {
		report("The value component of the XTextProperty structure was NULL.");
		FAIL;
	} else {
		CHECK;
		XFree((char*)tp.value);
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
