/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* 
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XrmParseCommand(database, table, table_count, name, argc_in_out, argv_in_out)
 *   XrmDatabase *database;
 *   XrmOptionDescList table;
 *   int table_count;
 *   char *name;
 *   int *argc_in_out;
 *   char **argv_in_out;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XrmParseCommand	1
char    *TestName = "XrmParseCommand";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XrmParseCommand function
 */
static XrmDatabase *database;
static XrmOptionDescList table;
static int table_count;
static char *name;
static int *argc_in_out;
static char **argv_in_out;



static XrmDatabase
xrm_create_database(data)
char *data;
{
	/* Create a new database for testing with */
	return(XrmGetStringDatabase(data));
}

static void
xrm_fill_value(value, data)
XrmValue *value;
char *data;
{
	value->addr = (caddr_t)data;
	value->size = (unsigned int)(strlen(data)+1);
}

static int
xrm_check_entry(dbase, fullspec, fullclass, type, val)
XrmDatabase dbase;
char *fullspec;
char *fullclass;
char *type;
char *val;
{
	int ret_val;
	char	*type_ret;
	XrmValue	value_ret;

	ret_val=0;
	type_ret=(char *)NULL;
	value_ret.size=0;
	value_ret.addr=(caddr_t)NULL;

	if(XrmGetResource(dbase, fullspec, fullclass, &type_ret, &value_ret)
		==False) {
		report("XrmGetResource failed to find database entry");
		report("Specifier was: %s", fullspec);
		ret_val++;
	} else {
		if (type_ret==NULL || strcmp(type_ret, type)) {
			report("XrmGetResource returned unexpected type information.");
			report("Specifier was: %s", fullspec);
			report("Expected type: '%s'", type);
			report("Returned type: '%s'",
				(type_ret==NULL)?"<NULL POINTER>":type_ret);
			ret_val++;
		}

		if (( value_ret.addr==(caddr_t)NULL)
			|| (strncmp((char *)value_ret.addr, val, strlen(val)))) {
			report("XrmGetResource returned unexpected value information.");
			report("Specifier was: %s", fullspec);
			report("Expected value: '%s'", val);
			if(value_ret.addr == (caddr_t)NULL) {
				report("Returned value: <NULL POINTER>");
			} else {
				report("Returned value: '%.*s' (%u bytes)",
					value_ret.size, (char *)value_ret.addr, value_ret.size);
			}
			ret_val++;
		}
	}

	return(ret_val);
}

static int
xrm_tabulate(from, into)
char *from, *into;
{
	int i,j;

	j = strlen(from);
	for(i=0; i<j; i++) {
		if(from[i]=='T') {
			into[i]='\t';
		} else {
			into[i]=from[i];
		}
	}
	return(j);
}

#define XPC_TESTS	12
#define XPC_MAXDBE	2
#define XPC_MAXAVE	6

/* XPC_DB_MODE means that failed database matches cause a failure, */
/* instead of deletion. */
#define XPC_DB_MODE	1

/* XPC_ARGC_MODE means that incorrect argc values returned cause a failure, */
/* instead of deletion. */
#define XPC_ARGC_MODE	2

/* XPC_NOREPORT_MODE suppresses the CHECKPASS call at the end of xpc_dotest. */
#define	XPC_NOREPORT_MODE	4

static XrmDatabase xpc_db;
static int xpc_argc;
static char *xpc_argv[XPC_MAXAVE];

/* Initial database contents */
static char *xpcdb_init[XPC_TESTS][XPC_MAXDBE][2] = {
	{ {NULL,NULL},	{NULL,NULL} },
	{ {NULL,NULL},	{NULL,NULL} },
	{ {NULL,NULL},	{NULL,NULL} },
	{ {NULL,NULL},	{NULL,NULL} },
	{ {"xtest.t5","i5"},	{NULL,NULL} },
	{ {"xtest.t6","i6"},	{"xtest.t1","i1"} },
	{ {"xtest.t7","i7"},	{"xtest.t1","i1"} },
	{ {"xtest.t1","i1"},	{"xtest.t2","i2"} },
	{ {"xtest.test","i9"},	{NULL,NULL} },
	{ {NULL,NULL},	{NULL,NULL} },
	{ {"xtest.tA","iA"},	{"xtest.tB","iB"} },
	{ {"xtest.tC","iC"},	{NULL,NULL} } };

/* Expected final database contents. */
static char *xpcdb_final[XPC_TESTS][XPC_MAXDBE][2] = {
	{ {"xtest.t1","v1"},	{NULL,NULL} },
	{ {"xtest.t2","bb"},	{NULL,NULL} },
	{ {"xtest.t3","a3"},	{NULL,NULL} },
	{ {"xtest.t4","a4"},	{NULL,NULL}},
	{ {"xtest.t5","i5"},	{"t","a5"} },
	{ {"xtest.t6","i6"},	{"xtest.t1","i1"} },
	{ {"xtest.t7","i7"},	{"xtest.t1","i1"} },
	{ {"xtest.t1","i1"},	{"xtest.t2","bb"} },
	{ {"xtesttest","v9"},	{"xtest.test","i9"} },
	{ {"xtest.tA","vA"},	{NULL,NULL} },
	{ {"xtest.tA","iA"},	{"xtest.tB","iB"} },
	{ {"xtest.tC","iC"},	{NULL,NULL} } };

/* Initial argc value. */
static int xpcac_init[XPC_TESTS] = {
	2, 2, 2, 3, 3, 3, 4, 5, 2, 2, 2, 2 };

/* Expected return argc value. */
static int xpcac_final[XPC_TESTS] = {
	1, 1, 1, 1, 1, 3, 4, 4, 1, 1, 2, 2 };

/* Initial argv vector contents */
static char *xpcav_init[XPC_TESTS][XPC_MAXAVE] = {
	{	"PROGNAME",	"aa",	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	"bb",	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	"cca3",	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	"dd",	"a4",	NULL,	NULL,	NULL },
	{	"PROGNAME",	"ee",	"t:a5",	NULL,	NULL,	NULL },
	{	"PROGNAME",	"ff",	"aa",	NULL,	NULL,	NULL },
	{	"PROGNAME",	"gg",	"left",	"aa",	NULL,	NULL },
	{	"PROGNAME",	"hh",	"left",	"aa",	"bb",	NULL },
	{	"PROGNAME",	"ii",	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	"jj",	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	"j",	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	"LL",	NULL,	NULL,	NULL,	NULL } };

/* Expected argv vector contents */
static char *xpcav_final[XPC_TESTS][XPC_MAXAVE] = {
	{	"PROGNAME",	NULL,	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	NULL,	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	NULL,	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	NULL,	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	NULL,	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	"ff",	"aa",	NULL,	NULL,	NULL },
	{	"PROGNAME",	"gg",	"left",	"aa",	NULL,	NULL },
	{	"PROGNAME",	"hh",	"left",	"aa",	NULL,	NULL },
	{	"PROGNAME",	NULL,	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	NULL,	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	"j",	NULL,	NULL,	NULL,	NULL },
	{	"PROGNAME",	"LL",	NULL,	NULL,	NULL,	NULL } };

/* Test XrmOptionDescRec table. */
static XrmOptionDescRec xpc_table[XPC_TESTS] = {
	{	"aa",	".t1",	XrmoptionNoArg,		"v1" 	},
	{	"bb",	".t2",	XrmoptionIsArg,		"v2"	},
	{	"cc",	".t3",	XrmoptionStickyArg,	"v3"	},
	{	"dd",	".t4",	XrmoptionSepArg,	"v4"	},
	{	"ee",	".t5",	XrmoptionResArg,	"v5"	},
	{	"ff",	".t6",	XrmoptionSkipArg,	"v6"	},
	{	"gg",	NULL,	XrmoptionSkipLine,	NULL	},
	{	"hh",	NULL,	XrmoptionSkipNArgs,	(char *)2	},
/* Adds prefix without binding test. */
	{	"ii",	"test",	XrmoptionNoArg,		"v9"	},
/* Unambiguous match tests. */
	{	"jjj",	".tA",	XrmoptionNoArg,		"vA"	},
	{	"jk",	".tB",	XrmoptionNoArg,		"vB"	},
/* Case sensitivity test */
	{	"ll",	".tC",	XrmoptionNoArg,		"vC"	} };

static int
xpc_dotest(n, mode)
int n;
int mode;
{
	int a;
	int pass=0;
	int fail=0;
/* Create new database to perform tests on. */
	xpc_db = xrm_create_database("");
	if (xpc_db == (XrmDatabase)NULL) {
		delete("Could not create test database.");
		return(0);
	} else
		CHECK;

/* Load database with initial values, if any. */
	for(a=0; a<XPC_MAXDBE; a++) {
		CHECK;
		if (xpcdb_init[n][a][0] != NULL) {
			XrmPutStringResource(database,
				xpcdb_init[n][a][0],
				xpcdb_init[n][a][1]);
		}
	}

/* Initialise test argc and argv */
	xpc_argc = xpcac_init[n];
	for(a=0; a<XPC_MAXAVE; a++) {
		CHECK;
		xpc_argv[a]=xpcav_init[n][a];
	}

/* Call xname to parse the argc,argv pair. */
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmParseCommand(database, table, table_count, name, argc_in_out, argv_in_out);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that argc was updated as expected. */
	if (xpc_argc != xpcac_final[n]) {
		if(mode & XPC_ARGC_MODE) {
			FAIL;
			report("%s did not set argc_in_out as expected.", TestName);
			report("Expected argc_in_out: %d", xpcac_final[n]);
			report("Returned argc_in_out: %d", xpc_argc);
		} else {
			CHECK;
			trace("%s did not set argc_in_out as expected.", TestName);
			trace("Expected argc_in_out: %d", xpcac_final[n]);
			trace("Returned argc_in_out: %d", xpc_argc);
		}
	} else
		CHECK;

/* Verify that argv was updated as expected. */
	for(a=0; a<xpcac_final[n]; a++) {
		if(xpc_argv[a] == NULL ||
			strcmp(xpc_argv[a], xpcav_final[n][a])) {
			if(mode & XPC_DB_MODE) {
				FAIL;
				report("Expected argv_in_out[%d]: %s", a,
					xpcav_final[n][a]);
				report("Returned argv_in_out[%d]: %s", a,
					xpc_argv[a]);
			} else {
				CHECK;
				trace("Expected argv_in_out[%d]: %s", a,
					xpcav_final[n][a]);
				trace("Returned argv_in_out[%d]: %s", a,
					xpc_argv[a]);
			}
		} else
			CHECK;
	}

/* Verify that the database was updated as expected. */
	for(a=0; a<XPC_MAXDBE; a++) {
		if(xpcdb_final[n][a][0]!=NULL) {
			if(xrm_check_entry(xpc_db,
				xpcdb_final[n][a][0], xpcdb_final[n][a][0],
				"String", xpcdb_final[n][a][1])) {
				if(mode & XPC_DB_MODE) {
					FAIL;
					report("%s did not update the database",
						TestName);
					report("as expected.");
				} else {
					CHECK;
					trace("%s did not update the database",
						TestName);
					trace("as expected.");
				}
			} else
				CHECK;
		} else
			CHECK;
	}

#ifdef	TESTING
	{	/* If the database contents are required for investigation,  */
		/* Compile with pmake CFLOCAL=-DTESTING to dump the database */
		char tf[20];
		sprintf(tf, "xpc_%d.%d", n, mode);
		XrmPutFileDatabase(xpc_db, tf);
		trace("Database dumped to '%s'", tf);
	}
#endif
	XrmDestroyDatabase(xpc_db);

	if (!(mode & XPC_NOREPORT_MODE)) {
		CHECKPASS(1+XPC_MAXDBE+XPC_MAXAVE+1+xpcac_final[n]+XPC_MAXDBE);
		return(0);
	} else {
		return(pass==(1+XPC_MAXDBE+XPC_MAXAVE+1+xpcac_final[n]+XPC_MAXDBE)?1:0);
	}
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	database = &xpc_db;
	table = xpc_table;
	table_count = XPC_TESTS;
	name = "xtest";
	argc_in_out = &xpc_argc;
	argv_in_out = xpc_argv;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

/* Including from file rescommon.mc */
/* End of included file rescommon.mc */

static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XrmParseCommand-1.(A)");
	report_assertion("When an argument in argv_in_out matches an option within");
	report_assertion("table whose argKind is XrmoptionNoArg, then a call to");
	report_assertion("XrmParseCommand stores the resource specifier with value");
	report_assertion("value and representation type String in the database");
	report_assertion("database and removes the argument from argv_in_out.");

	report_strategy("Create new database to perform tests on.");
	report_strategy("Load database with initial values, if any.");
	report_strategy("Initialise test argc and argv");
	report_strategy("Call XrmParseCommand to parse the argc,argv pair.");
	report_strategy("Verify that argv was updated as expected.");
	report_strategy("Verify that the database was updated as expected.");

	tpstartup();
	setargs();
	(void)xpc_dotest(0, XPC_DB_MODE);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XrmParseCommand-2.(A)");
	report_assertion("When an argument in argv_in_out matches an option within");
	report_assertion("table whose argKind is XrmoptionIsArg, then a call to");
	report_assertion("XrmParseCommand stores the resource specifier with the value");
	report_assertion("set to the argument and representation type String in the");
	report_assertion("database database and removes the argument from argv_in_out.");

	report_strategy("Create new database to perform tests on.");
	report_strategy("Load database with initial values, if any.");
	report_strategy("Initialise test argc and argv");
	report_strategy("Call XrmParseCommand to parse the argc,argv pair.");
	report_strategy("Verify that argv was updated as expected.");
	report_strategy("Verify that the database was updated as expected.");

	tpstartup();
	setargs();
	(void)xpc_dotest(1, XPC_DB_MODE);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XrmParseCommand-3.(A)");
	report_assertion("When an argument in argv_in_out matches an option within");
	report_assertion("table whose argKind is XrmoptionStickyArg, then a call to");
	report_assertion("XrmParseCommand stores the resource specifier with the value");
	report_assertion("set to the characters immediately following the argument and");
	report_assertion("representation type String in the database database and");
	report_assertion("removes the argument from argv_in_out.");

	report_strategy("Create new database to perform tests on.");
	report_strategy("Load database with initial values, if any.");
	report_strategy("Initialise test argc and argv");
	report_strategy("Call XrmParseCommand to parse the argc,argv pair.");
	report_strategy("Verify that argv was updated as expected.");
	report_strategy("Verify that the database was updated as expected.");

	tpstartup();
	setargs();
	(void)xpc_dotest(2, XPC_DB_MODE);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XrmParseCommand-4.(A)");
	report_assertion("When an argument in argv_in_out matches an option within");
	report_assertion("table whose argKind is XrmoptionSepArg, then a call to");
	report_assertion("XrmParseCommand stores the resource specifier with the value");
	report_assertion("set to the next argument and representation type String in");
	report_assertion("the database database and removes both arguments from");
	report_assertion("argv_in_out.");

	report_strategy("Create new database to perform tests on.");
	report_strategy("Load database with initial values, if any.");
	report_strategy("Initialise test argc and argv");
	report_strategy("Call XrmParseCommand to parse the argc,argv pair.");
	report_strategy("Verify that argv was updated as expected.");
	report_strategy("Verify that the database was updated as expected.");

	tpstartup();
	setargs();
	(void)xpc_dotest(3, XPC_DB_MODE);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XrmParseCommand-5.(A)");
	report_assertion("When an argument in argv_in_out matches an option within");
	report_assertion("table whose argKind is XrmoptionResArg, then a call to");
	report_assertion("XrmParseCommand stores the resource and value specified by");
	report_assertion("the next argument and representation type String in the");
	report_assertion("database database and removes both arguments from");
	report_assertion("argv_in_out.");

	report_strategy("Create new database to perform tests on.");
	report_strategy("Load database with initial values, if any.");
	report_strategy("Initialise test argc and argv");
	report_strategy("Call XrmParseCommand to parse the argc,argv pair.");
	report_strategy("Verify that argv was updated as expected.");
	report_strategy("Verify that the database was updated as expected.");

	tpstartup();
	setargs();
	(void)xpc_dotest(4, XPC_DB_MODE);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XrmParseCommand-6.(A)");
	report_assertion("When an argument in argv_in_out matches an option within");
	report_assertion("table whose argKind is XrmoptionSkipArg, then a call to");
	report_assertion("XrmParseCommand ignores the argument and the following");
	report_assertion("argument.");

	report_strategy("Create new database to perform tests on.");
	report_strategy("Load database with initial values, if any.");
	report_strategy("Initialise test argc and argv");
	report_strategy("Call XrmParseCommand to parse the argc,argv pair.");
	report_strategy("Verify that argv was updated as expected.");
	report_strategy("Verify that the database was updated as expected.");

	tpstartup();
	setargs();
	(void)xpc_dotest(5, XPC_DB_MODE);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XrmParseCommand-7.(A)");
	report_assertion("When an argument in argv_in_out matches an option within");
	report_assertion("table whose argKind is XrmoptionSkipLine, then a call to");
	report_assertion("XrmParseCommand ignores the argument and the rest of");
	report_assertion("argv_in_out.");

	report_strategy("Create new database to perform tests on.");
	report_strategy("Load database with initial values, if any.");
	report_strategy("Initialise test argc and argv");
	report_strategy("Call XrmParseCommand to parse the argc,argv pair.");
	report_strategy("Verify that argv was updated as expected.");
	report_strategy("Verify that the database was updated as expected.");

	tpstartup();
	setargs();
	(void)xpc_dotest(6, XPC_DB_MODE);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XrmParseCommand-8.(A)");
	report_assertion("When an argument in argv_in_out matches an option within");
	report_assertion("table whose argKind is XrmoptionSkipNArgs, then a call to");
	report_assertion("XrmParseCommand ignores the argument and the following value");
	report_assertion("arguments of argv_in_out.");

	report_strategy("Create new database to perform tests on.");
	report_strategy("Load database with initial values, if any.");
	report_strategy("Initialise test argc and argv");
	report_strategy("Call XrmParseCommand to parse the argc,argv pair.");
	report_strategy("Verify that argv was updated as expected.");
	report_strategy("Verify that the database was updated as expected.");

	tpstartup();
	setargs();
	(void)xpc_dotest(7, XPC_DB_MODE);

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int a;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XrmParseCommand-9.(A)");
	report_assertion("On a call to XrmParseCommand, the argc_in_out argument is");
	report_assertion("set to the remaining number of arguments that were not");
	report_assertion("parsed.");

	report_strategy("Create new database to perform tests on.");
	report_strategy("Load database with initial values, if any.");
	report_strategy("Initialise test argc and argv");
	report_strategy("Call XrmParseCommand to parse the argc,argv pair.");
	report_strategy("Verify that argc was updated as expected.");

	tpstartup();
	setargs();
	for(a=0; a<8; a++) {
		trace("testing parse table line %d",a);
		if(xpc_dotest(a, XPC_ARGC_MODE|XPC_NOREPORT_MODE)) {
			CHECK;
		} else
			FAIL;
	}

	CHECKPASS(8);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.9923 */
static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XrmParseCommand-10.(B)");
	report_assertion("On a call to XrmParseCommand, the name is prefixed without");
	report_assertion("a binding character to the specifier in the option table");
	report_assertion("before storing the specification in the database.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.9923 */

static void t011(){

int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XrmParseCommand-11.(A)");
	report_assertion("On a call to XrmParseCommand, any unambiguous abbreviation");
	report_assertion("within argv_in_out for an option member of table is");
	report_assertion("considered a match for the option.");

	report_strategy("Create new database to perform tests on.");
	report_strategy("Load database with initial values, if any.");
	report_strategy("Initialise test argc and argv");
	report_strategy("Call XrmParseCommand to parse the argc,argv pair.");
	report_strategy("Verify that argc was updated as expected.");
	report_strategy("Verify that argv was updated as expected.");
	report_strategy("Verify that the database was updated as expected.");

	tpstartup();
	setargs();
	if(xpc_dotest(9, XPC_DB_MODE|XPC_ARGC_MODE|XPC_NOREPORT_MODE)) {
		CHECK;
	} else {
		FAIL;
		report("Unambiguous abbreviation failed to match.");
	}

	if(xpc_dotest(10, XPC_DB_MODE|XPC_ARGC_MODE|XPC_NOREPORT_MODE)) {
		CHECK;
	} else {
		FAIL;
		report("Ambiguous abbreviation matched incorrectly.");
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XrmParseCommand-12.(A)");
	report_assertion("On a call to XrmParseCommand, the case of arguments is");
	report_assertion("significant.");

	report_strategy("Create new database to perform tests on.");
	report_strategy("Load database with initial values, if any.");
	report_strategy("Initialise test argc and argv");
	report_strategy("Call XrmParseCommand to parse the argc,argv pair.");
	report_strategy("Verify that argc was updated as expected.");
	report_strategy("Verify that argv was updated as expected.");
	report_strategy("Verify that the database was updated as expected.");

	tpstartup();
	setargs();
	(void)xpc_dotest(11, XPC_DB_MODE|XPC_ARGC_MODE);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = rmstartup;
void	(*tet_cleanup)() = cleanup;
