/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XUnmapSubwindows(display, w)
 *   Display	*display;
 *   Window	w;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XUnmapSubwindows	1
char    *TestName = "XUnmapSubwindows";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XUnmapSubwindows function
 */
static Display	*display;
static Window	w;



/*
 * Tree of children (which are unmapped) and other descendents (which are
 * not).  One window is already unmapped.
 */
static	char	*T1[] = {
	".",
	"A . (5,5) 30x10",
	  "A1 A (2,2) 12x4",
	"B . (10,20) 10x26",
	  "B1 B (1,5) 5x4",
	"C . (66,16) 17x45",
	  "C1 C (4,10) 10x5",
	  "C2 C (4,30) 10x5",
	"D . (37,32) 15x8 unmap",
	"E . (30,58) 9x14",
	"F . (2,70) 21x19",
	  "F1 F (3,3) 8x7",
};
#define	NT1	(NELEM(T1))		/* Number of windows */
#define	NT1SUB	(NELEM(T1)-1)	/* Number of subwindows */
#define	NT1MAPSUB	5	/* A, B, C, E, F */



#define	GOT_WINDOW	01
#define	GOT_PARENT	02


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

struct	buildtree	*bt;
XWindowAttributes	atts;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XUnmapSubwindows-1.(A)");
	report_assertion("A call to XUnmapSubwindows unmaps all subwindows of the");
	report_assertion("specified window in bottom to top stacking order.");

	report_strategy("Create subwindows.");
	report_strategy("Draw on subwindows.");
	report_strategy("Unmap subwindows.");
	report_strategy("Verify that map state of each child is IsUnmapped.");
	report_strategy("Verify that map state of inferiors of children is IsUnviewable.");
	report_strategy("Verify that subwindow have disappeared from screen.");

	tpstartup();
	setargs();
	w = defwin(display);
	bt = buildtree(display, w, T1, NT1);

	for (i = 1; i < NT1; i++)
		pattern(display, bt[i].wid);

	startcall(display);
	if (isdeleted())
		return;
	XUnmapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = 1; i < NT1; i++) {
		XGetWindowAttributes(display, bt[i].wid, &atts);

		if (bt[i].parent == bt) {
			/* This is a direct child of the test window */
			if (atts.map_state != IsUnmapped) {
				report("After unmap of window '%s', map-state was %s, expecting IsUnmapped",
					bt[i].name, mapstatename(atts.map_state));
				FAIL;
			} else
				CHECK;
		} else {
			/* This is an inferior of a child */
			if (atts.map_state != IsUnviewable) {
				report("After unmap of window '%s', map-state was %s, expecting IsUnviewable",
					bt[i].name, mapstatename(atts.map_state));
				FAIL;
			} else
				CHECK;
		}
	}

	if (checkclear(display, w))
		CHECK;
	else {
		report("Window did not disappear after unmapping");
		FAIL;
	}

	CHECKPASS(NT1SUB+1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XEvent	ev;
XUnmapEvent	*ump;
XUnmapEvent	good;
struct	buildtree	*bt;
struct	buildtree	*btp;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XUnmapSubwindows-2.(A)");
	report_assertion("A call to XUnmapSubwindows generates an UnmapNotify event");
	report_assertion("on each subwindow that was originally mapped.");

	report_strategy("Create parent window.");
	report_strategy("Create inferior windows.");
	report_strategy("Select SubstructureNotify on parent.");
	report_strategy("Select StructureNotify on inferiors.");
	report_strategy("Call XUnmapSubwindows.");
	report_strategy("Verify that UnmapNotify is received on child windows.");
	report_strategy("Verify that UnmapNotify is received on parent for each child.");
	report_strategy("Verify that not events are received for other inferiors.");

	tpstartup();
	setargs();
	w = defwin(display);
	bt = buildtree(display, w, T1, NT1);

	for (i = 1; i < NT1; i++) {
		pattern(display, bt[i].wid);
		XSelectInput(display, bt[i].wid, StructureNotifyMask);
	}

	XSelectInput(display, w, SubstructureNotifyMask);

	startcall(display);
	if (isdeleted())
		return;
	XUnmapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = 1; i < NT1; i++)
		XSelectInput(display, bt[i].wid, NoEventMask);
	XSelectInput(display, w, NoEventMask);

	/* This loop is traversed twice for each mapped child */
	while (getevent(display, &ev)) {
		if (ev.type != UnmapNotify) {
			report("Event of type %s was received unexpectedly", eventname(ev.type));
			FAIL;
			continue;
		} else
			CHECK;

		ump = (XUnmapEvent*)&ev;
		btp = btwtobtp(bt, ump->window);
		if (btp == NULL) {
			report("Event received for a window that was not in the test");
			FAIL;
			continue;
		}

		/*
		 * This checks the window and event fields.  As events arrive they
		 * are recorded in the bt structure.
		 */
		if (ump->event == ump->window) {
			/* Event arrived on the window */
			if (btp->uflags & GOT_WINDOW) {
				report("Repeat event received on window '%s'", btp->name);
				FAIL;
			} else {
				btp->uflags |= GOT_WINDOW;
				CHECK;
			}
		} else if (ump->event != w) {
			/* Event arrived somewhere unexpected */
			report("Event received for window '%s' on a window other than the parent", btp->name);
			FAIL;
		} else {
			/* Event arrived on the parent */
			if (btp->uflags & GOT_PARENT) {
				report("Repeat event received on parent for window '%s'", btp->name);
				FAIL;
			} else {
				btp->uflags |= GOT_PARENT;
				CHECK;
			}
		}

		/* Check the rest of the fields */
		good.type = UnmapNotify;
		good.serial = 0L;
		good.send_event = False;
		good.display = display;
		good.event = ump->event;
		good.window = ump->window;
		good.from_configure = False;

		if (checkevent((XEvent*)&good, &ev))
			FAIL;
		else
			CHECK;
	}

	for (i = 1; i < NT1; i++) {
		/*
		 * If this is a mapped child then should have events for
		 * window and parent.
		 * Otherwise and for other inferiors - no events.
		 */
		if (bt[i].parent == bt && !(bt[i].opts & BT_UNMAP)) {
			/* child */
			if (bt[i].uflags & GOT_WINDOW)
				CHECK;
			else {
				report("Did not receive unmap event for window '%s'", bt[i].name);
				FAIL;
			}

			if (bt[i].uflags & GOT_PARENT)
				CHECK;
			else {
				report("Did not receive unmap event on parent for window '%s'", bt[i].name);
				FAIL;
			}
		} else {
			/* Other inferior or unmapped */
			if (bt[i].uflags & GOT_WINDOW) {
				report("Received unexpected unmap event for window '%s'", bt[i].name);
				if (bt[i].opts & BT_UNMAP)
					report("  window was already unmapped");
				FAIL;
			} else
				CHECK;

			if (bt[i].uflags & GOT_PARENT) {
				/* Getting here is very wrong */
				report("Received unexpected unmap event on parent of window '%s'", bt[i].name);
				if (bt[i].opts & BT_UNMAP)
					report("  window was already unmapped");
				FAIL;
			} else
				CHECK;
		}
	}

	CHECKPASS(3*2*NT1MAPSUB+2*NT1SUB);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

struct	buildtree	*bt;
XImage	*imp;
int 	n;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XUnmapSubwindows-3.(A)");
	report_assertion("When all the subwindows are already unmapped, then a call");
	report_assertion("to XUnmapSubwindows has no effect.");

	report_strategy("Create parent window.");
	report_strategy("Create inferiors.");
	report_strategy("Unmap all children.");
	report_strategy("Select StructureNotify on inferiors.");
	report_strategy("Call XUnmapSubwindows to unmap subwindows again.");
	report_strategy("Verify that no UnmapNotify event is received on window.");
	report_strategy("Verify that no change occurs on screen.");

	tpstartup();
	setargs();
	w = defwin(display);
	bt = buildtree(display, w, T1, NT1);

	startcall(display);
	if (isdeleted())
		return;
	XUnmapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = 1; i < NT1; i++) {
		pattern(display, bt[i].wid);
		XSelectInput(display, bt[i].wid, StructureNotifyMask);
	}
	imp = savimage(display, w);

	startcall(display);
	if (isdeleted())
		return;
	XUnmapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = 1; i < NT1; i++)
		XSelectInput(display, bt[i].wid, NoEventMask);

	n = XPending(display);
	if (n != 0) {
		report("Received event when subwindows already unmapped");
		FAIL;
	} else
		CHECK;

	if (compsavimage(display, w, imp))
		CHECK;
	else {
		report("Screen contents changed when unmapped windows were unmapped again");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XUnmapSubwindows-4.(A)");
	report_assertion("When a call to XUnmapSubwindows uncovers part of any window");
	report_assertion("that was formerly obscured, then either Expose events are");
	report_assertion("generated or the contents are restored from backing store.");

	report_strategy("Create base window.");
	report_strategy("Call setforexpose() on base window.");
	report_strategy("Enable expose events.");
	report_strategy("Create subwindows to unmap.");
	report_strategy("Call XUnmapSubwindows to unmap subwindows.");
	report_strategy("Verify expose or backing store restore occurred with exposecheck().");

	tpstartup();
	setargs();
	w = defwin(display);
	buildtree(display, w, T1, NT1);

	setforexpose(display, w);
	XSelectInput(display, w, ExposureMask);

	startcall(display);
	if (isdeleted())
		return;
	XUnmapSubwindows(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (exposecheck(display, w))
		CHECK;
	else {
		report("Neither Expose events or backing store processing");
		report("could correctly restore the window contents.");
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XUnmapSubwindows-5.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XUnmapSubwindows(display, w);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
