/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* 
* 
* SCCS:  @(#)  allcnmdclr.m Rel 1.10	    (12/10/91)
* 
* 	UniSoft Ltd., London, England
* 
* (C) Copyright 1991 X/Open Company Limited
* 
* All rights reserved.  No part of this source code may be reproduced,
* stored in a retrieval system, or transmitted, in any form or by any
* means, electronic, mechanical, photocopying, recording or otherwise,
* except as stated in the end-user licence agreement, without the prior
* permission of the copyright owners.
* 
* X/Open and the 'X' symbol are trademarks of X/Open Company Limited in
* the UK and other countries.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XAllocNamedColor(display, colormap, color_name, screen_def_return, exact_def_return)
 *   Display *display;
 *   Colormap colormap;
 *   char *color_name;
 *   XColor *screen_def_return;
 *   XColor *exact_def_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XAllocNamedColor	1
char    *TestName = "XAllocNamedColor";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_COLORMAP colormap


/*
 * Arguments to the XAllocNamedColor function
 */
static Display *display;
static Colormap colormap;
static char *color_name;
static XColor *screen_def_return;
static XColor *exact_def_return;


static int 	StatusReturn;


XColor dummycol;

static char *convertname(s)
char *s;
{
	char *res;
	char *rp;
	char *cp = s;
	int  len = strlen(s);

	if(s == NULL)
		return(NULL);

	if((res = rp = (char*) malloc(len + 1)) == NULL) {
		delete("Malloc returned NULL.");
		return(NULL);
	}

	while(*cp == ' ')
		cp++;
		
	*rp++ = toupper(*cp++);
	while(*cp) {
		if(*cp == ' ') {
			while(*cp == ' ')
				cp++;
			if(*cp)
				*rp++ = toupper(*cp++);
		} else
			*rp++ = *cp++;
	}

	*rp = '\0';
	return(res);
}


static int
compare(col1, col2, name1, name2, eflag)
XColor	*col1;
XColor	*col2;
char	*name1;
char	*name2;
int	eflag;
{

	if((col2->red == col1->red) &&
	   (col2->green == col1->green) &&
 	   (col2->blue == col1->blue) ) {
		report("Colour names \"%s\" and \"%s\" yield the same %s rgb values.",
			name1, name2, eflag ? "exact" : "supported");
		trace("%s = r %u g %u b %u,  %s = r %u g %u b %u",
		name1, col1->red, col1->green, col1->blue,
		name2, col2->red, col2->green, col2->blue);
		return(0);
	} 
	return(1);
}	

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	colormap = DefaultColormap(display, DefaultScreen(display));
	color_name = "";
	screen_def_return = &dummycol;
	exact_def_return = &dummycol;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int		i;
int		firstunsupported;
int		secondunsupported;
XVisualInfo 	*vp;
Status		status;
XColor 		exactcol, screencol;
XColor 		exactcol2, screencol2;
unsigned long 	vmask;
static char	*p[5][2] = 
	{{ "gray", "grey"},
	 { "dark gray", "dark grey"},
	 { "dark slate gray", "dark slate grey"},
	 { "dim gray", "dim grey"},
	 { "light gray", "light grey"}};
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XAllocNamedColor-1.(A)");
	report_assertion("When a colour name in the table is recognised on a call to");
	report_assertion("XAllocNamedColor, then all other colour names on the same");
	report_assertion("line of the table are also recognised on another call to");
	report_assertion("XAllocNamedColor using the same display and colormap, and");
	report_assertion("the same values are returned by each call to");
	report_assertion("XAllocNamedColor in the red, green and blue components of");
	report_assertion("the XColor structures named by the exact_def_return argument");
	report_assertion("and screen_def_return arguments.");

	report_strategy("For each supported visual type:");
	report_strategy("  Create a colourmap of that type using XCreateColormap.");
	report_strategy("  For each equivalent colour name:");
	report_strategy("    Obtain the rgb values for the colour.");
	report_strategy("    Verify that the exact rgb values are identical.");
	report_strategy("    Verify that the supported rbg values are identical.");
	report_strategy("    Free the allocated colourmap cell using XFreeColors.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals reported as valid.");
		return;
	} else
		CHECK;

	for(resetsupvis(vmask); nextsupvis(&vp); ) {

		colormap = makecolmap(display, vp->visual, AllocNone);
		for(i=0; i< NELEM(p); i++) {

			firstunsupported = secondunsupported = 0;
			trace("Compare \"%s\" against \"%s\".", p[i][0], p[i][1]);

			exact_def_return = &exactcol;
			screen_def_return = &screencol;
			color_name= p[i][0];
		
			startcall(display);
			if (isdeleted())
				return;
			status = XAllocNamedColor(display, colormap, color_name, screen_def_return, exact_def_return);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

	
			if( status == (Status) 0) {
				trace("Colour \"%s\" is not supported.", color_name);
				firstunsupported = 1;
			} else
				XFreeColors(display, colormap, &exactcol.pixel, 1, (unsigned long)0);

			exact_def_return = &exactcol2;
			screen_def_return = &screencol2;
			color_name= p[i][1];

			startcall(display);
			if (isdeleted())
				return;
			status = XAllocNamedColor(display, colormap, color_name, screen_def_return, exact_def_return);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			if( status == (Status) 0) {
				trace("Colour \"%s\" is not supported.", color_name);
				secondunsupported = 1;
			} else
				XFreeColors(display, colormap, &(exactcol2.pixel), 1, (unsigned long)0);
	
			if(firstunsupported && secondunsupported) {
				CHECK;
				CHECK;				
				CHECK;
				continue;
			}

			if(firstunsupported && !secondunsupported) {
				report("Colour %s is unsupported.", p[i][0]);
				report("Colour %s is supported.", p[i][1]);
				FAIL;
			} else if(!firstunsupported && secondunsupported) {
				report("Colour %s is unsupported.", p[i][1]);
				report("Colour %s is supported.", p[i][0]);
				FAIL;
			} else {
				CHECK;

				if((exactcol2.red != exactcol.red) ||
				   (exactcol2.green != exactcol.green) ||
			 	   (exactcol2.blue != exactcol.blue) ) {
					report("Colour names \"%s\" and \"%s\" do not yield the same exact rgb values.",
						p[i][0], p[i][1]);
					report("( r %u g %u b %u instead of r %u g %u b %u respectively.)", 
						exactcol.red, exactcol.green, exactcol.blue,
						exactcol2.red, exactcol2.green, exactcol2.blue);
					FAIL;
				} else
					CHECK;
	
				if((screencol2.red != screencol.red) ||
				   (screencol2.green != screencol.green) ||
			 	   (screencol2.blue != screencol.blue) ) {
					report("Colour names \"%s\" and \"%s\" do not yield the same supported rgb values.",
						p[i][0], p[i][1]);
					report("( r %u g %u b %u instead of r %u g %u b %u respectively.)", 
						screencol.red, screencol.green, screencol.blue,
						screencol2.red, screencol2.green, screencol2.blue);
					FAIL;
				} else
					CHECK;
			}

		}
	}

	CHECKPASS(1 + 3 * nsupvis() * NELEM(p) );

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XColor		scols[43];
XColor		ecols[43];
XColor		scols2[5];
XColor		ecols2[5];
Status		status;
int		i, j;
unsigned long	vmask;
XVisualInfo	*vp;
static char	*list[43] = {
				"gray",
				"dark gray",
				"dark slate gray",
				"dim gray",
				"light gray",
				"black",
				"white",
				"blue",
				"cyan",
				"green",
				"magenta",
				"red",
				"yellow",
				"dark blue",
				"brown",
				"dark cyan",
				"dark green",
				"dark magenta",
				"dark red",
				"medium blue",
				"midnight blue",
				"navy blue",
				"sky blue",
				"coral",
				"gold",
				"light green",
				"forest green",
				"lime green",
				"pale green",
				"spring green",
				"maroon",
				"orange",
				"pink",
				"indian red",
				"orange red",
				"violet red",
				"salmon",
				"sienna",
				"tan",
				"turquoise",
				"violet",
				"blue violet",
				"wheat"};
static char	*list2[5] = {
				"grey",
				"dark grey",
				"dark slate grey",
				"dim grey",
				"light grey"};
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XAllocNamedColor-2.(A)");
	report_assertion("When a colour name in the table is recognised on a call to");
	report_assertion("XAllocNamedColor, and a colour name on a different line of");
	report_assertion("the table is also recognised on another call to");
	report_assertion("XAllocNamedColor using the same display and colormap, then");
	report_assertion("distinct values are returned by each call to");
	report_assertion("XAllocNamedColor in the red, green and blue components of");
	report_assertion("the XColor structures named by the exact_def_return argument");
	report_assertion("and screen_def_return arguments.");

	report_strategy("For each supported visual:");
	report_strategy("  Create a colourmap of that type using XCreateColormap.");
	report_strategy("  For each pair of colour names in the table:");
	report_strategy("    Obtain the rgb values corresponding to the name using XAllocNamedColor.");
	report_strategy("    Verify that the rgb triples are different.");
	report_strategy("    Free the allocated colourmap cell using XFreeColors.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals reported as valid.");
		return;
	} else
		CHECK;

	for(resetsupvis(vmask); nextsupvis(&vp); ) {

		colormap = makecolmap(display, vp->visual, AllocNone);
		for(i=0; i<NELEM(list); i++) {

			color_name = list[i];
			exact_def_return = &ecols[i];
			screen_def_return = &scols[i];
	
			startcall(display);
			if (isdeleted())
				return;
			status = XAllocNamedColor(display, colormap, color_name, screen_def_return, exact_def_return);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
	
			if(status == 0) {
				trace("Colour \"%s\" is not supported.", color_name);
				ecols[i].flags = 0;
			} else {
				XFreeColors(display, colormap, &ecols[i].pixel, 1, (unsigned long)0);
				ecols[i].flags = 1;
			}
	
			if(i==0)
				CHECK;
		}

		/*
		 * test all pairs of colours -   n!
		 *			     2!(n-2)!
		 */
		for(i=0; i<NELEM(list)-1; i++) {
			for(j=i+1; j<NELEM(list); j++) {
				if((ecols[i].flags) && (ecols[j].flags)) {
					if(compare(&ecols[i], &ecols[j], list[i], list[j], 1) == 0)
						FAIL;
					if(compare(&scols[i], &scols[j], list[i], list[j], 0) == 0)
						FAIL;
				}
			}
					
			if(i==0)
				CHECK;
		}

		for(i=0; i<NELEM(list2); i++) {

			color_name = list2[i];
			exact_def_return = &ecols2[i];
			screen_def_return = &scols2[i];
	
			startcall(display);
			if (isdeleted())
				return;
			status = XAllocNamedColor(display, colormap, color_name, screen_def_return, exact_def_return);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
	
			if(status == 0) {
				trace("Colour \"%s\" is not supported.", color_name);
				ecols2[i].flags = 0;
			} else {
				XFreeColors(display, colormap, &ecols[i].pixel, 1, (unsigned long)0);
				ecols2[i].flags = 1;
			}
	
			if(i==0)
				CHECK;
		}

		for(i=0; i<NELEM(list2)-1; i++) {
			for(j=i+5; j<NELEM(list); j++) {
				if((ecols2[i].flags) && (ecols[j].flags)) {
					if(compare(&ecols2[i], &ecols[j], list2[i], list[j], 1) == 0)
						FAIL;
					if(compare(&scols2[i], &scols[j], list2[i], list[j], 0) == 0)
						FAIL;
				}
			}
					
			if(i==0)
				CHECK;

		}
	}

	CHECKPASS(1 + nsupvis() * 4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int		i;
XVisualInfo	*vp;
Status		status;
XColor 		exactcol, screencol;
XColor 		exactcol2, screencol2;
unsigned long 	vmask;
static char		*list[] = {
			"black",
			"white",
			"blue",
			"cyan",
			"green",
			"magenta",
			"red",
			"yellow",
			"gray",
			"grey",
			"dark gray",
			"dark grey",
			"dark blue",
			"brown",
			"dark cyan",
			"dark green",
			"dark magenta",
			"dark red",
			"medium blue",
			"midnight blue",
			"navy blue",
			"sky blue",
			"coral",
			"gold",
			"dark slate gray",
			"dark slate grey",
			"dim gray",
			"dim grey",
			"light gray",
			"light grey",
			"light green",
			"forest green",
			"lime green",
			"pale green",
			"spring green",
			"maroon",
			"orange",
			"pink",
			"indian red",
			"orange red",
			"violet red",
			"salmon",
			"sienna",
			"tan",
			"turquoise",
			"violet",
			"blue violet",
			"wheat" };
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XAllocNamedColor-3.(A)");
	report_assertion("When a colour name in the table is recognised on a call to");
	report_assertion("XAllocNamedColor, then the colour name with the first");
	report_assertion("letter of each word in upper-case and with no spaces between");
	report_assertion("words is also recognised on another call to XAllocNamedColor");
	report_assertion("using the same display and colormap, and the same values");
	report_assertion("are returned by each call to XAllocNamedColor in the red,");
	report_assertion("green and blue components of the XColor structures named by");
	report_assertion("the exact_def_return argument and screen_def_return");
	report_assertion("arguments.");

	report_strategy("For each supported visual type:");
	report_strategy("  Create a colourmap of that type using XCreateColormap.");
	report_strategy("  For each equivalent colour name:");
	report_strategy("    Obtain the rgb values for the colour.");
	report_strategy("    Verify that the exact rgb values are identical.");
	report_strategy("    Verify that the supported rbg values are identical.");
	report_strategy("    Free the allocated colourmap cell using XFreeColors.");

	tpstartup();
	setargs();

	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals reported as valid.");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		
		for(i=0; i< NELEM(list); i++) {

			color_name = list[i];
			colormap = makecolmap(display, vp->visual, AllocNone);
			exact_def_return = &exactcol;
			screen_def_return = &screencol;
			startcall(display);
			if (isdeleted())
				return;
			status = XAllocNamedColor(display, colormap, color_name, screen_def_return, exact_def_return);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			if(status == (Status) 0) {
				trace("Colour name \"%s\" is not supported.", color_name);
				CHECK; CHECK;CHECK;
			} else {
				XFreeColors(display, colormap, &exactcol.pixel, 1, (unsigned long)0);
				
				color_name = convertname(list[i]);
				exact_def_return = &exactcol2;
				screen_def_return = &screencol2;
				startcall(display);
				if (isdeleted())
					return;
				status = XAllocNamedColor(display, colormap, color_name, screen_def_return, exact_def_return);
				endcall(display);
				if (geterr() != Success) {
					report("Got %s, Expecting Success", errorname(geterr()));
					FAIL;
				}

				if(status == 0) {
					report("Colour name \"%s\" is supported but \"%s\" is not.", list[i], color_name);
					FAIL;
				} else {

					XFreeColors(display, colormap, &exactcol.pixel, 1, (unsigned long)0);
					CHECK;

					if((exactcol2.red != exactcol.red) ||
					   (exactcol2.green != exactcol.green) ||
				 	   (exactcol2.blue != exactcol.blue) ) {
						report("Colour names \"%s\" and \"%s\" do not yield the same exact rgb values.",
							list[i], color_name);
						report("( r %u g %u b %u instead of r %u g %u b %u respectively.)", 
							exactcol.red, exactcol.green, exactcol.blue,
							exactcol2.red, exactcol2.green, exactcol2.blue);
						FAIL;
					} else
						CHECK;
	
					if((screencol2.red != screencol.red) ||
					   (screencol2.green != screencol.green) ||
				 	   (screencol2.blue != screencol.blue) ) {
						report("Colour names \"%s\" and \"%s\" do not yield the same supported rgb values.",
							list[i], color_name);
						report("( r %u g %u b %u instead of r %u g %u b %u respectively.)", 
							screencol.red, screencol.green, screencol.blue,
							screencol2.red, screencol2.green, screencol2.blue);
						FAIL;
					} else
						CHECK;


				}

				if(!isdeleted())
					free(color_name);

			}
		}

	}

	CHECKPASS(nsupvis() * 3 * NELEM(list));

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int		i;
Status		status;
XVisualInfo	*vp;
XColor		exactcol;
unsigned long	vmask;
static char	*list[] = { "black", "white" };
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XAllocNamedColor-4.(A)");
	report_assertion("All colour names in the table which are in set A are");
	report_assertion("recognised on a call to XAllocNamedColor.");

	report_strategy("For each supported visual type:");
	report_strategy("  Create a colourmap of that type using XCreateColormap.");
	report_strategy("  For the colournames in the table:");
	report_strategy("    Obtain the rgb values for the colour using XAllocNamedColor.");
	report_strategy("    Verify that the call did not return 0.");
	report_strategy("    Free the allocated colourmap cell using XFreeColors.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals reported as valid.");
		return;
	} else
		CHECK;

	exact_def_return = &exactcol;
	for(resetsupvis(vmask); nextsupvis(&vp); ) {

		colormap = makecolmap(display, vp->visual, AllocNone);

		for(i=0; i< NELEM(list); i++) {

			color_name = list[i];
			startcall(display);
			if (isdeleted())
				return;
			status = XAllocNamedColor(display, colormap, color_name, screen_def_return, exact_def_return);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			if(status == 0) {
				report("Colour name \"%s\" is not supported.", list[i]);
				FAIL;
			} else {
				XFreeColors(display, colormap, &exactcol.pixel, 1, (unsigned long)0);
				CHECK;
			}
		}
	}

	CHECKPASS(1 + nsupvis() * NELEM(list));

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int		i;
Status		status;
XVisualInfo	*vp;
XColor		exactcol;
unsigned long 	vmask;
static char	*list[] = { "gray", "grey", "dark gray", "dark grey" };
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XAllocNamedColor-5.(C)");
	report_assertion("If any of the visual classes GrayScale or StaticGray");
	report_assertion("support colourmaps with at least four colour cells: When the");
	report_assertion("visual type of the colormap argument is GrayScale or");
	report_assertion("StaticGray, and colormap has at least four colour cells,");
	report_assertion("then all colour names in the table which are in set M are");
	report_assertion("recognised on a call to XAllocNamedColor.");

	report_strategy("If the server supports GrayScale or StaticGray with colourmap size greater than 4:");
	report_strategy("  For those supported visuals:");
	report_strategy("    Create a colourmap using XCreateColormap.");
	report_strategy("    For each colour name in the table:");
	report_strategy("      Obtain the rgb values for the for the colour using XAllocNamedColor.");
	report_strategy("      Verify that the call did not return 0.");
	report_strategy("      Free the allocated colourmap cell using XFreeColors.");

	tpstartup();
	setargs();

	if( (vmask = visualsupported(display, 1L<<GrayScale)) != 0L) {

		resetsupvis(vmask);
		nextsupvis(&vp);
		if(vp->colormap_size < 4)
			vmask = 0L;
	}


	if( (vmask |= visualsupported(display, 1L<<StaticGray)) | StaticGray) {

		resetsupvis(1L<<StaticGray);
		nextsupvis(&vp);
		if(vp->colormap_size < 4)
			vmask &= ~(1L<<StaticGray);
	}

	if(vmask == 0L) {
		unsupported("StaticGray and GrayScale visuals are not supported.");
		return;
	} else
		CHECK;

	exact_def_return = &exactcol;
	for(resetsupvis(vmask); nextsupvis(&vp); ) {

		colormap = makecolmap(display, vp->visual, AllocNone);
		for(i=0; i< NELEM(list); i++) {

			color_name = list[i];
			startcall(display);
			if (isdeleted())
				return;
			status = XAllocNamedColor(display, colormap, color_name, screen_def_return, exact_def_return);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			if(status == 0L) {
				report("Colour name \"%s\" is not supported.", color_name);
				FAIL;
			} else {
				XFreeColors(display, colormap, &exactcol.pixel, 1, (unsigned long)0);
				CHECK;
			}
		}
	}

	CHECKPASS(1 + nsupvis()* NELEM(list));

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int		i;
unsigned long	vmask = (1L<<PseudoColor|1L<<StaticColor|1L<<TrueColor|1L<<DirectColor);
Status		status;
XVisualInfo	*vp;
XColor		exactcol;
static char	*list[] = { "blue", "cyan", "green", "magenta", "red", "yellow" };
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XAllocNamedColor-6.(C)");
	report_assertion("If any of the visual classes PseudoColor, StaticColor,");
	report_assertion("TrueColor, or DirectColor are supported: When the visual");
	report_assertion("type of the colormap argument is PseudoColor, StaticColor,");
	report_assertion("TrueColor, or DirectColor, then all colour names in the");
	report_assertion("table which are in set C are recognised on a call to");
	report_assertion("XAllocNamedColor.");

	report_strategy("For each supported visual type from PseudoColor, StaticColor, TrueColor and DirectColor:");
	report_strategy("  Create a colourmap of that type using XCreateColormap.");
	report_strategy("  For the colournames in the table:");
	report_strategy("    Obtain the rgb values for the colour using XAllocNamedColor.");
	report_strategy("    Verify that the call did not return 0.");
	report_strategy("    Free the allocated colourmap cell using XFreeColors.");

	tpstartup();
	setargs();


	if( (vmask = visualsupported(display, vmask)) == 0L) {
		unsupported("Required visual types are not supported.");
		return;
	} else
		CHECK;


	exact_def_return = &exactcol;
	for(resetsupvis(vmask); nextsupvis(&vp); ) {

		colormap = makecolmap(display, vp->visual, AllocNone);
		for(i=0; i< NELEM(list); i++) {

			color_name = list[i];
			startcall(display);
			if (isdeleted())
				return;
			status = XAllocNamedColor(display, colormap, color_name, screen_def_return, exact_def_return);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}

			if(status == 0L) {
				report("Colour name \"%s\" is not supported.", color_name);
				FAIL;
			} else {
				XFreeColors(display, colormap, &exactcol.pixel, 1, (unsigned long)0);
				CHECK;
			}
		}
	}

	CHECKPASS(nsupvis() * NELEM(list) + 1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

XVisualInfo	*vp;
unsigned long	vmask;
int		i;
int		j;
int		supported = 0;
int		unsupported = 0;
Status		status;
XColor		exactcol;
static char *MVX[] = {	"gray", "grey", "dark gray","dark grey","dark blue","brown","dark cyan","dark green","dark magenta",
			"dark red","medium blue","midnight blue","navy blue","sky blue","coral","gold","dark slate gray",
			"dark slate grey","dim gray","dim grey","light gray","light grey", "light green", "forest green",
			"lime green","pale green","spring green","maroon","orange","pink","indian red","orange red",
			"violet red","salmon","sienna","tan","turquoise","violet","blue violet","wheat" };
static char *CMV[] = {	"blue","cyan","green","magenta","red","yellow","gray","grey","dark gray","dark grey",
			"dark blue","brown","dark cyan","dark green","dark magenta","dark red"};
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XAllocNamedColor-7.(A)");
	report_assertion("When a colour name in the table which is in set M, V or X");
	report_assertion("is recognised on a call to XAllocNamedColor, then all other");
	report_assertion("colour names in the table which are in set C, M, or V are");
	report_assertion("also recognised on another call to XAllocNamedColor.");

	report_strategy("If a colourname in sets M, V or X causes XAllocNamedColor to return non-zero:");
	report_strategy("  For each supported visual:");
	report_strategy("    Verify that all the colour names in C, M and V also cause XAllocNamedColor to return non-zero:");
	report_strategy("    Free the allocated colourmap cell using XFreeColors.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals reported as valid.");
		return;
	} else
		CHECK;

	exact_def_return = &exactcol;
	for(resetsupvis(vmask); nextsupvis(&vp); ) {

		colormap = makecolmap(display, vp->visual, AllocNone);
		i = 0;
		supported = 0;
		color_name = MVX[i];
		startcall(display);
		if (isdeleted())
			return;
		status = XAllocNamedColor(display, colormap, color_name, screen_def_return, exact_def_return);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if(status != 0) {
			supported++;
			XFreeColors(display, colormap, &exactcol.pixel, 1, (unsigned long)0);
			break;
		} else
			unsupported++;
	}

	if(unsupported == NELEM(MVX) && supported == 0) {
		PASS;
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		colormap = makecolmap(display, vp->visual, AllocNone);
		for(j=0; j<NELEM(CMV); j++) {				
			color_name = CMV[j];
			startcall(display);
			if (isdeleted())
				return;
			status = XAllocNamedColor(display, colormap, color_name, screen_def_return, exact_def_return);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
			if(status == (Status) 0) {
				report("Colour name \"%s\" is not supported.", color_name);
				FAIL;
			} else {
				XFreeColors(display, colormap, &exactcol.pixel, 1, (unsigned long)0);
				CHECK;
			}
		}
	}

	CHECKPASS(NELEM(CMV) * nsupvis() + 1);

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
