/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Boolean
 *   XtIsSensitive()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

extern char *event_names[];

void XtEVT_AcceptInput(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
	avs_set_event(1, 1);
	exit(0);
}

void XtEVT_Proc(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
	sprintf(ebuf, "ERROR: Event %s invoked XtEVT_Proc", event_names[event->type]);
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
}

/* procedure XtTMO_Proc to be invoked */
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	exit(0);
}


#define T_XtIsSensitive	1
char    *TestName = "XtIsSensitive";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XtWidgetGeometry intended, geom;
Boolean sensitive;
Widget labelw_msg;
char *msg = "Test widget";
pid_t pid2;
int invoked;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtIsSensitive-1.(A)");
	report_assertion("A call to Boolean XtIsSensitive(w) when the class of the");
	report_assertion("widget w is a subclass of RectObject and the sensitive and");
	report_assertion("ancestor_sensitive fields of the widget are True shall");
	report_assertion("return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tissenstv1", "XtIsSensitive");
	tet_infoline("PREP: Create test label widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register XtEVT_AcceptInput to handle events for");
	tet_infoline("PREP: labelw_msg widget");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_AcceptInput,
		 (XtPointer)NULL
		 );
	tet_infoline("PREP: Set the sensitivity of test widget and its ancestor to True");
	XtSetSensitive(labelw_msg,True);
	XtSetSensitive(boxw1,True);
	tet_infoline("TEST: Labelw_msg widget is sensitive");
	sensitive = XtIsSensitive(labelw_msg);
	check_dec(True, sensitive, "XtIsSensitive");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Send ButtonPress over wire");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, FALSE);
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: XtEVT_AcceptInput was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtEVT_AcceptInput invoked count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11408 */
/* End of included file Mdefcode.tmc.11408 */

static void t002(){

XtWidgetGeometry intended, geom;
Boolean sensitive;
Widget labelw_msg;
char *msg = "Test widget";
pid_t pid2;
int invoked;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtIsSensitive-2.(A)");
	report_assertion("A call to Boolean XtIsSensitive(w) when the class of the");
	report_assertion("widget w is not a subclass of RectObject, shall return");
	report_assertion("False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tissenstv2", "XtIsSensitive");
	tet_infoline("PREP: Create test label widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register procedure XtEVT_Proc to handle events for");
	tet_infoline("PREP: labelw_msg widget");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_Proc,
		 (Widget)NULL
		 );
	tet_infoline("PREP: Set the sensitivity of test widget to False");
	XtSetSensitive(labelw_msg, False);
	tet_infoline("TEST: labelw_msg widget is not sensitve");
	sensitive = XtIsSensitive(labelw_msg);
	check_dec(False, sensitive, "XtIsSensitive");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Simulate ButtonPress on widget labelw_msg");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, FALSE);
	tet_infoline("PREP: Register timeout procedure");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("TEST: Procedure XtEVT_Proc was not invoked");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11408 */
/* End of included file Mdefcode.tmc.11408 */

static void t003(){

XtWidgetGeometry intended, geom;
Boolean sensitive;
Widget labelw_msg;
char *msg = "Test widget";
int invoked;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtIsSensitive-3.(A)");
	report_assertion("A call to Boolean XtIsSensitive(w) when the sensitive field");
	report_assertion("of the widget w is not True shall return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tissenstv1", "XtIsSensitive");
	tet_infoline("PREP: Create test label widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Set the sensitivity of test widget to False");
	XtSetSensitive(labelw_msg,False);
	tet_infoline("TEST: labelw_msg widget is not sensitive");
	sensitive = XtIsSensitive(labelw_msg);
	check_dec(False, sensitive, "XtIsSensitive");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11408 */
/* End of included file Mdefcode.tmc.11408 */

static void t004(){

XtWidgetGeometry intended, geom;
Boolean sensitive;
Widget labelw_msg;
char *msg = "Test widget";
int invoked;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtIsSensitive-4.(A)");
	report_assertion("A call to Boolean XtIsSensitive(w) when the");
	report_assertion("ancestor_sensitive field of the widget w is not True shall");
	report_assertion("return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tissenstv1", "XtIsSensitive");
	tet_infoline("PREP: Create test label widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Set the ancestor sensitivity of test widget to False");
	XtSetSensitive(boxw1,False);
	XtSetSensitive(labelw_msg,True);
	tet_infoline("TEST: labelw_msg widget is not sensitive");
	sensitive = XtIsSensitive(labelw_msg);
	check_dec(False, sensitive, "XtIsSensitive");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11408 */
/* End of included file Mdefcode.tmc.11408 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
