.\"
.\" Copyright (c) 1996  Joe Moss, The XFree86 Project
.\"
.de EX
.RS
.nf
.sp 1
.if t \{\
.  ie \\n(.g .ft CR
.  el .ft CW
.\}
..
.de EE
.ft
.sp 1
.fi
.if t .ft R
.RE
..
.TH XF86VIDMODE __libmansuffix__ 2013-07-05 __vendorversion__
.SH NAME
XF86VidModeQueryExtension, XF86VidModeQueryVersion,
XF86VidModeSetClientVersion, XF86VidModeGetModeLine,
XF86VidModeGetAllModeLines, XF86VidModeAddModeLine,
XF86VidModeDeleteModeLine, XF86VidModeModModeLine,
XF86VidModeValidateModeLine, XF86VidModeSwitchMode,
XF86VidModeSwitchToMode, XF86VidModeLockModeSwitch, XF86VidModeGetMonitor,
XF86VidModeGetViewPort, XF86VidModeSetViewPort, XF86VidModeGetDotClocks,
XF86VidModeGetGamma, XF86VidModeSetGamma, XF86VidModeGetGammaRamp,
XF86VidModeSetGammaRamp, XF86VidModeGetGammaRampSize,
XF86VidModeGetPermissions \- Extension library for the XFree86-VidMode X
extension
.SH SYNOPSIS
.nf
\&#include <X11/extensions/xf86vmode.h>
.sp
Bool XF86VidModeQueryExtension(
    Display *\fIdisplay\fP\^,
    int *\fIevent_base_return\fP\^,
    int *\fIerror_base_return\fP\^);
.sp
Bool XF86VidModeQueryVersion(
    Display *\fIdisplay\fP\^,
    int *\fImajor_version_return\fP\^,
    int *\fIminor_version_return\fP\^);
.sp
Bool XF86VidModeSetClientVersion(
    Display *\fIdisplay\fP\^);
.sp
Bool XF86VidModeGetModeLine(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int *\fIdotclock_return\fP\^,
    XF86VidModeModeLine *\fImodeline\fP\^);
.sp
Bool XF86VidModeGetAllModeLines(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int *\fImodecount_return\fP\^,
    XF86VidModeModeInfo ***\fImodesinfo\fP\^);
.sp
Bool XF86VidModeAddModeLine(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeModeInfo *\fImodeline\fP\,
    XF86VidModeModeInfo *\fIaftermode\fP\^);
.sp
Bool XF86VidModeDeleteModeLine(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeModeInfo *\fImodeline\fP\^);
.sp
Bool XF86VidModeModModeLine(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeModeLine *\fImodeline\fP\^);
.sp
Status XF86VidModeValidateModeLine(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeModeLine *\fImodeline\fP\^);
.sp
Bool XF86VidModeSwitchMode(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int \fIzoom\fP\^);
.sp
Bool XF86VidModeSwitchToMode(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeModeInfo *\fImodeline\fP\^);
.sp
Bool XF86VidModeLockModeSwitch(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int \fIlock\fP\^);
.sp
Bool XF86VidModeGetMonitor(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeMonitor *\fImonitor\fP\^);
.sp
Bool XF86VidModeGetViewPort(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int *\fIx_return\fP\^,
    int *\fIy_return\fP\^);
.sp
Bool XF86VidModeSetViewPort(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int \fIx\fP\^,
    int \fIy\fP\^);
.sp
XF86VidModeGetDotClocks(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int *\fIflags return\fP\^,
    int *\fInumber of clocks return\fP\^,
    int *\fImax dot clock return\fP\^,
    int **\fIclocks return\fP\^);
.sp
XF86VidModeGetGamma(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeGamma *\fIGamma\fP\^);
.sp
XF86VidModeSetGamma(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    XF86VidModeGamma *\fIGamma\fP\^);
.sp
XF86VidModeGetGammaRamp(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int \fIsize\fP\^,
    unsigned short *\fIred array\fP\^,
    unsigned short *\fIgreen array\fP\^,
    unsigned short *\fIblue array\fP\^);
.sp
XF86VidModeSetGammaRamp(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int \fIsize\fP\^,
    unsigned short *\fIred array\fP\^,
    unsigned short *\fIgreen array\fP\^,
    unsigned short *\fIblue array\fP\^);
.sp
XF86VidModeGetGammaRampSize(
    Display *\fIdisplay\fP\^,
    int \fIscreen\fP\^,
    int *\fIsize\fP\^);
.fi
.SH ARGUMENTS
.IP \fIdisplay\fP 2i
Specifies the connection to the X server.
.IP \fIscreen\fP 2i
Specifies which screen number the setting apply to.
.IP \fIevent_base_return\fP 2i
Returns the base event number for the extension.
.IP \fIerror_base_return\fP 2i
Returns the base error number for the extension.
.IP \fImajor_version_return\fP 2i
Returns the major version number of the extension.
.IP \fIminor_version_return\fP 2i
Returns the minor version number of the extension.
.IP \fIdotclock_return\fP 2i
Returns the clock for the mode line.
.IP \fImodecount_return\fP 2i
Returns the number of video modes available in the server.
.IP \fIzoom\fP 2i
If greater than zero, indicates that the server should switch to
the next mode, otherwise switch to the previous mode.
.IP \fIlock\fP 2i
Indicates that mode switching should be locked, if non-zero.
.IP \fImodeline\fP 2i
Specifies or returns the timing values for a video mode.
.IP \fIaftermode\fP 2i
Specifies the timing values for the video mode after which the
new mode will added.
.IP \fImodesinfo\fP 2i
Returns the timing values and dotclocks for all of the available
video modes.
.IP \fImonitor\fP 2i
Returns information about the monitor.
.IP \fIx\fP 2i
Specifies the desired X location for the viewport.
.IP \fIx_return\fP 2i
Returns the current X location of the viewport.
.IP \fIy\fP 2i
Specifies the desired Y location for the viewport.
.IP \fIy_return\fP 2i
Returns the current Y location of the viewport.
.SH STRUCTURES
\fIVideo Mode Settings:\fP
.EX
typedef struct {
    unsigned short      hdisplay;       /\(** Number of display pixels horizontally */
    unsigned short      hsyncstart;     /\(** Horizontal sync start */
    unsigned short      hsyncend;       /\(** Horizontal sync end */
    unsigned short      htotal;         /\(** Total horizontal pixels */
    unsigned short      vdisplay;       /\(** Number of display pixels vertically */
    unsigned short      vsyncstart;     /\(** Vertical sync start */
    unsigned short      vsyncend;       /\(** Vertical sync start */
    unsigned short      vtotal;         /\(** Total vertical pixels */
    unsigned int        flags;          /\(** Mode flags */
    int privsize;                       /\(** Size of private */
    INT32       *private;               /\(** Server privates */
} XF86VidModeModeLine;
.sp
typedef struct {
    unsigned int        dotclock;       /\(** Pixel clock */
    unsigned short      hdisplay;       /\(** Number of display pixels horizontally */
    unsigned short      hsyncstart;     /\(** Horizontal sync start */
    unsigned short      hsyncend;       /\(** Horizontal sync end */
    unsigned short      htotal;         /\(** Total horizontal pixels */
    unsigned short      vdisplay;       /\(** Number of display pixels vertically */
    unsigned short      vsyncstart;     /\(** Vertical sync start */
    unsigned short      vsyncend;       /\(** Vertical sync start */
    unsigned short      vtotal;         /\(** Total vertical pixels */
    unsigned int        flags;          /\(** Mode flags */
    int privsize;                       /\(** Size of private */
    INT32       *private;               /\(** Server privates */
} XF86VidModeModeInfo;
.EE
.LP
\fIMonitor information:\fP
.EX
typedef struct {
    char*       vendor;                /\(** Name of manufacturer */
    char*       model;                 /\(** Model name */
    float       EMPTY;                 /\(** unused, for backward compatibility */
    unsigned char nhsync;              /\(** Number of horiz sync ranges */
    XF86VidModeSyncRange* hsync;       /\(** Horizontal sync ranges */
    unsigned char nvsync;              /\(** Number of vert sync ranges */
    XF86VidModeSyncRange* vsync;       /\(** Vertical sync ranges */
} XF86VidModeMonitor;
.sp
typedef struct {
    float       hi;     /\(** Top of range */
    float       lo;     /\(** Bottom of range */
} XF86VidModeSyncRange;
.sp
typedef struct {
    int type;                   /\(** of event */
    unsigned long serial;       /\(** # of last request processed by server */
    Bool send_event;            /\(** true if this came from a SendEvent req */
    Display *display;           /\(** Display the event was read from */
    Window root;                /\(** root window of event screen */
    int state;                  /\(** What happened */
    int kind;                   /\(** What happened */
    Bool forced;                /\(** extents of new region */
    Time time;                  /\(** event timestamp */
} XF86VidModeNotifyEvent;
.sp
typedef struct {
    float red;                  /\(** Red Gamma value */
    float green;                /\(** Green Gamma value */
    float blue;                 /\(** Blue Gamma value */
} XF86VidModeGamma;
.EE
.SH DESCRIPTION
These functions provide an interface to the server extension
.B XFree86-VidModeExtension
which allows the video modes to be
queried and adjusted dynamically and mode switching to be controlled.
Applications that use these functions must be linked with the
.B \-lXxf86vm
flag.
.SS MODELINE FUNCTIONS
The
.B XF86VidModeGetModeLine
function is used to query the settings for the currently selected video mode.
The calling program should pass a pointer to a
.B XF86VidModeModeLine
structure that it has already allocated.
The function fills in the fields of the structure.
.PP
If there are any server private values (currently only applicable to
the S3 server) the function will allocate storage for them.
Therefore, if the
.I privsize
field is non-zero, the calling program should call
.B Xfree(private)
to free the storage.
.PP
.B XF86VidModeGetAllModeLines
returns the settings for all video modes.
The calling program supplies the address of a pointer which will be
set by the function to point to an array of
.B XF86VidModeModeInfo
structures.
The memory occupied by the array is dynamically allocated by the
.B XF86VidModeGetAllModeLines
function and should be freed by the caller.
The first element of the array corresponds to the current video mode.
.PP
The
.B XF86VidModeModModeLine
function can be used to change the settings of the current video mode
provided the requested settings are valid (e.g., they don't exceed the
capabilities of the monitor).
.PP
To add a mode to the list of available modes, the
.B XF86VidModeAddModeLine
function can be used.
Assuming the settings are valid, the video mode will be added after
the existing mode which matches the timings specified by the
.I aftermode
parameter.
To be considered a match, all of the fields of the given
.B XF86VidModeModeInfo
structure must match, except the
.I privsize
and
.I private
fields.
If the
.I aftermode
parameter is zero, the mode will be added
after the current mode.
.PP
Modes can be deleted with the
.B XF86VidModeDeleteModeLine
function.
The specified mode must match an existing mode.
To be considered a match, all of the fields of the given
.B XF86VidModeModeInfo
structure must match, except the
.I privsize
and
.I private
fields.
If the mode to be deleted is the current mode, a mode switch
to the next mode will occur first.
The last remaining mode can not be deleted.
.PP
The validity of a mode can be checked with the
.B XF86VidModeValidateModeLine
function.
If the specified mode can be used by the server (i.e., meets all the
constraints placed upon a mode by the combination of the server, card,
and monitor) the function returns
.BR MODE_OK ,
otherwise it returns a value indicating the reason why the mode is
invalid (as defined in \fIxf86vmode.h\fP).
.SS MODE SWITCH FUNCTIONS
When the function
.B XF86VidModeSwitchMode
is called, the server will change the video mode to next (or previous)
video mode.
The
.B XF86VidModeSwitchToMode
function can be used to switch directly to the specified mode.
Matching is as specified in the description of the
.B XF86VidModeAddModeLine
function above.
The
.B XF86VidModeLockModeSwitch
function can be used to allow or disallow mode switching whether
the request to switch modes comes from a call to the
.B XF86VidModeSwitchMode
or
.B XF86VidModeSwitchToMode
functions or from one of the mode switch key sequences.
.PP
.BR Note :
Because of the asynchronous nature of the X protocol, a call to
.B XFlush
is needed if the application wants to see the mode change immediately.
To be informed of the execution status of the request,
a custom error handler should be installed using
.B XSetErrorHandler
before calling the mode switching function.
.SS MONITOR FUNCTIONS
Information known to the server about the monitor is returned by the
.B XF86VidModeGetMonitor
function.
The
.I hsync
and
.I vsync
fields each point to an array of
.B XF86VidModeSyncRange
structures.
The arrays contain
.I nhsync
and
.I nvsync
elements, respectively.
The
.I hi
and
.I low
values will be equal if a discrete value was given in the
.BR xorg.conf (5)
file.
.PP
The
.IR vendor ,
.IR model ,
.IR hsync ,
and
.I vsync
fields point to dynamically allocated storage that should be freed
by the caller.
.SS VIEWPORT FUNCTIONS
The
.B XF86VidModeGetViewPort
and
.B XF86VidModeSetViewPort
functions can be used to, respectively, query and change the location
of the upper left corner of the viewport into the virtual screen.
.SS OTHER FUNCTIONS
The
.B XF86VidModeQueryVersion
function can be used to determine the version of the extension
built into the server.
.PP
The function
.B XF86VidModeQueryExtension
returns the lowest numbered error and event values
assigned to the extension.
.SH BUGS
The
.BR XF86VidModeSetClientVersion ,
.BR XF86VidModeGetDotClocks ,
.BR XF86VidModeGetGamma ,
.BR XF86VidModeSetGamma ,
.BR XF86VidModeSetGammaRamp ,
.BR XF86VidModeGetGammaRamp ,
.BR XF86VidModeGetGammaRampSize ,
and
.B XF86VidModeGetPermissions
functions need to be documented.
In the meantime, check the source code for information about how to use them.
.SH SEE ALSO
.BR Xorg (1),
.BR xvidtune (1),
.BR XFlush (__libmansuffix__),
.BR XSetErrorHandler (__libmansuffix__),
.BR xorg.conf (5),
.BR X (7)
.SH AUTHORS
Kaleb Keithley, Jon Tombs, David Dawes, and Joe Moss
